/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiled.operator;

import org.apache.sling.scripting.sightly.impl.compiled.ExpressionTranslator;
import org.apache.sling.scripting.sightly.impl.compiled.JavaSource;
import org.apache.sling.scripting.sightly.impl.compiled.Type;
import org.apache.sling.scripting.sightly.impl.compiled.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.OpHelper;
import org.apache.sling.scripting.sightly.impl.compiled.operator.TypedNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BinaryOperator;
import org.apache.sling.scripting.sightly.impl.compiler.util.expression.SideEffectVisitor;

public class ComparisonOpGen
implements BinaryOpGen {
    private final String javaOperator;
    private final boolean inverted;
    private final String runtimeMethod;

    public ComparisonOpGen(BinaryOperator operator) {
        switch (operator) {
            case LT: {
                this.runtimeMethod = BinaryOperator.METHOD_LT;
                this.inverted = false;
                this.javaOperator = "<";
                break;
            }
            case GT: {
                this.runtimeMethod = BinaryOperator.METHOD_LEQ;
                this.inverted = true;
                this.javaOperator = ">";
                break;
            }
            case LEQ: {
                this.runtimeMethod = BinaryOperator.METHOD_LEQ;
                this.inverted = false;
                this.javaOperator = "<=";
                break;
            }
            case GEQ: {
                this.runtimeMethod = BinaryOperator.METHOD_LT;
                this.inverted = true;
                this.javaOperator = ">=";
                break;
            }
            default: {
                throw new IllegalArgumentException("Operator is not a comparison operator: " + (Object)((Object)operator));
            }
        }
    }

    @Override
    public Type returnType(Type left, Type right) {
        return Type.BOOLEAN;
    }

    @Override
    public void generate(JavaSource source, ExpressionTranslator visitor, TypedNode left, TypedNode right) {
        Type type = OpHelper.sameType(left, right);
        if (OpHelper.isNumericType(type)) {
            this.generateWithOperator(source, visitor, left.getNode(), right.getNode());
        } else {
            this.generateGeneric(source, visitor, left.getNode(), right.getNode());
        }
    }

    private void generateGeneric(JavaSource source, SideEffectVisitor visitor, ExpressionNode leftNode, ExpressionNode rightNode) {
        if (this.inverted) {
            source.negation().startExpression();
        }
        source.startMethodCall(BinaryOperator.OBJECT_NAME, this.runtimeMethod);
        leftNode.accept(visitor);
        source.separateArgument();
        rightNode.accept(visitor);
        source.endCall();
        if (this.inverted) {
            source.endExpression();
        }
    }

    private void generateWithOperator(JavaSource source, SideEffectVisitor visitor, ExpressionNode leftNode, ExpressionNode rightNode) {
        leftNode.accept(visitor);
        source.append(this.javaOperator);
        rightNode.accept(visitor);
    }
}

