/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.compiler.CompilationResult;
import org.apache.sling.commons.compiler.CompilationUnit;
import org.apache.sling.commons.compiler.CompilerMessage;
import org.apache.sling.commons.compiler.Options;
import org.apache.sling.jcr.compiler.JcrJavaCompiler;
import org.apache.sling.scripting.sightly.ResourceResolution;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.impl.compiler.CompilerException;
import org.apache.sling.scripting.sightly.impl.engine.UnitChangeMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={SightlyJavaCompilerService.class})
public class SightlyJavaCompilerService {
    private static final Logger LOG = LoggerFactory.getLogger(SightlyJavaCompilerService.class);
    @Reference
    private ClassLoaderWriter classLoaderWriter = null;
    @Reference
    private JcrJavaCompiler jcrJavaCompiler = null;
    @Reference
    private UnitChangeMonitor unitChangeMonitor = null;
    private Options options;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();

    public Object getInstance(ResourceResolver resolver, Resource callingScript, String className) {
        Resource pojoResource;
        if (className.contains(".")) {
            String pojoPath = this.getPathFromJavaName(resolver, className);
            if (this.unitChangeMonitor.getLastModifiedDateForJavaUseObject(pojoPath) > 0L) {
                Resource pojoResource2 = resolver.getResource(pojoPath);
                if (pojoResource2 != null) {
                    this.unitChangeMonitor.clearJavaUseObject(pojoPath);
                    return this.compileSource(pojoResource2, className);
                }
                throw new SightlyException(String.format("Resource %s identifying class %s has been removed.", pojoPath, className));
            }
            try {
                return this.loadObject(className);
            }
            catch (CompilerException cex) {
                Resource pojoResource3 = resolver.getResource(pojoPath);
                if (pojoResource3 != null) {
                    return this.compileSource(pojoResource3, className);
                }
            }
        } else if (callingScript != null && (pojoResource = ResourceResolution.getResourceFromSearchPath(callingScript, className + ".java")) != null) {
            return this.getInstance(resolver, null, this.getJavaNameFromPath(pojoResource.getPath()));
        }
        throw new SightlyException("Cannot find class " + className + ".");
    }

    public Object compileSource(Resource javaResource, String fqcn) {
        LOG.debug("Compiling Sightly based Java class from resource: " + javaResource.getPath());
        try {
            SightlyCompilationUnit compilationUnit = new SightlyCompilationUnit(javaResource, fqcn);
            return this.compileJavaResource(compilationUnit, javaResource.getPath());
        }
        catch (Exception e) {
            throw new CompilerException(CompilerException.CompilerExceptionCause.COMPILER_ERRORS, (Throwable)e);
        }
    }

    private Set<String> getPossiblePojoPaths(String originalPath) {
        AmbiguousPathSymbol[] symbols;
        LinkedHashSet<String> possiblePaths = new LinkedHashSet<String>();
        possiblePaths.add(originalPath);
        HashMap<Integer, String> chars = new HashMap<Integer, String>();
        for (AmbiguousPathSymbol symbol : symbols = AmbiguousPathSymbol.values()) {
            String pathCopy = originalPath.substring(0, originalPath.lastIndexOf("/"));
            int actualIndex = 0;
            boolean firstPass = true;
            while (pathCopy.indexOf(symbol.getSymbol().charValue()) != -1) {
                int pos = pathCopy.indexOf(symbol.getSymbol().charValue());
                actualIndex += pos;
                if (!firstPass) {
                    ++actualIndex;
                }
                chars.put(actualIndex, symbol.getSymbol().toString());
                pathCopy = pathCopy.substring(pos + 1);
                firstPass = false;
            }
        }
        if (chars.size() > 0) {
            ArrayList<AmbiguousPathSymbol[]> possibleArrangements = new ArrayList<AmbiguousPathSymbol[]>();
            this.populateArray(possibleArrangements, new AmbiguousPathSymbol[chars.size()], 0);
            Integer[] indexes = chars.keySet().toArray(new Integer[chars.size()]);
            for (AmbiguousPathSymbol[] arrangement : possibleArrangements) {
                char[] possiblePath = originalPath.toCharArray();
                for (int i = 0; i < arrangement.length; ++i) {
                    char currentSymbol = arrangement[i].getSymbol().charValue();
                    int currentIndex = indexes[i];
                    possiblePath[currentIndex] = currentSymbol;
                }
                possiblePaths.add(new String(possiblePath));
            }
        }
        return possiblePaths;
    }

    private void populateArray(ArrayList<AmbiguousPathSymbol[]> arrayCollection, AmbiguousPathSymbol[] symbolsArrangementArray, int index) {
        if (symbolsArrangementArray.length > 0) {
            if (index == symbolsArrangementArray.length) {
                arrayCollection.add((AmbiguousPathSymbol[])symbolsArrangementArray.clone());
            } else {
                AmbiguousPathSymbol[] arr$ = AmbiguousPathSymbol.values();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    AmbiguousPathSymbol symbol;
                    symbolsArrangementArray[index] = symbol = arr$[i$];
                    this.populateArray(arrayCollection, symbolsArrangementArray, index + 1);
                }
            }
        }
    }

    private Object loadObject(String className) {
        try {
            this.readLock.lock();
            if (this.classLoaderWriter != null) {
                Object obj = this.classLoaderWriter.getClassLoader().loadClass(className).newInstance();
                return obj;
            }
            Object obj = Class.forName(className).newInstance();
            return obj;
        }
        catch (Throwable t) {
            throw new CompilerException(CompilerException.CompilerExceptionCause.COMPILER_ERRORS, t);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Object compileJavaResource(CompilationUnit compilationUnit, String scriptPath) throws Exception {
        this.writeLock.lock();
        try {
            long start = System.currentTimeMillis();
            CompilationResult compilationResult = this.jcrJavaCompiler.compile(new String[]{scriptPath}, this.options);
            long end = System.currentTimeMillis();
            List errors = compilationResult.getErrors();
            if (errors != null && errors.size() > 0) {
                throw new CompilerException(CompilerException.CompilerExceptionCause.COMPILER_ERRORS, this.createErrorMsg(errors));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("script compiled: {}", (Object)compilationResult.didCompile());
                LOG.debug("compilation took {}ms", (Object)(end - start));
            }
            Object t = compilationResult.loadCompiledClass(compilationUnit.getMainClassName()).newInstance();
            return t;
        }
        catch (Throwable t) {
            throw new CompilerException(CompilerException.CompilerExceptionCause.COMPILER_ERRORS, t);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Activate
    protected void activate() {
        LOG.info("Activating {}", (Object)this.getClass().getName());
        String version = System.getProperty("java.specification.version");
        this.options = new Options();
        this.options.put((Object)"generateDebugInfo", (Object)true);
        this.options.put((Object)"sourceVersion", (Object)version);
        this.options.put((Object)"targetVersion", (Object)version);
        this.options.put((Object)"classLoaderWriter", (Object)this.classLoaderWriter);
    }

    private String getJavaNameFromPath(String path) {
        if (path.endsWith(".java")) {
            path = path.substring(0, path.length() - 5);
        }
        return path.substring(1).replace("/", ".").replace("-", "_");
    }

    private String getPathFromJavaName(ResourceResolver resolver, String className) {
        boolean sightlyGeneratedClass = false;
        if (className.contains(".SightlyJava_")) {
            sightlyGeneratedClass = true;
        }
        String packageName = className.substring(0, className.lastIndexOf(46));
        String shortClassName = className.substring(packageName.length() + 1);
        String path = "/" + packageName.replace(".", "/").replace("_", "-") + "/" + shortClassName + ".java";
        if (sightlyGeneratedClass) {
            return path;
        }
        Set<String> possiblePaths = this.getPossiblePojoPaths(path);
        for (String possiblePath : possiblePaths) {
            if (resolver.getResource(possiblePath) == null) continue;
            return possiblePath;
        }
        return path;
    }

    private String createErrorMsg(List<CompilerMessage> errors) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Compilation errors in ");
        buffer.append(errors.get(0).getFile());
        buffer.append(":");
        StringBuilder errorsBuffer = new StringBuilder();
        boolean duplicateVariable = false;
        for (CompilerMessage e : errors) {
            if (!duplicateVariable && e.getMessage().contains("Duplicate local variable")) {
                duplicateVariable = true;
                buffer.append(" Maybe you defined more than one identical block elements without defining a different variable for each one?");
            }
            errorsBuffer.append("\nLine ");
            errorsBuffer.append(e.getLine());
            errorsBuffer.append(", column ");
            errorsBuffer.append(e.getColumn());
            errorsBuffer.append(" : ");
            errorsBuffer.append(e.getMessage());
        }
        buffer.append((CharSequence)errorsBuffer);
        return buffer.toString();
    }

    protected void bindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        this.classLoaderWriter = classLoaderWriter;
    }

    protected void unbindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        if (this.classLoaderWriter == classLoaderWriter) {
            this.classLoaderWriter = null;
        }
    }

    protected void bindJcrJavaCompiler(JcrJavaCompiler jcrJavaCompiler) {
        this.jcrJavaCompiler = jcrJavaCompiler;
    }

    protected void unbindJcrJavaCompiler(JcrJavaCompiler jcrJavaCompiler) {
        if (this.jcrJavaCompiler == jcrJavaCompiler) {
            this.jcrJavaCompiler = null;
        }
    }

    protected void bindUnitChangeMonitor(UnitChangeMonitor unitChangeMonitor) {
        this.unitChangeMonitor = unitChangeMonitor;
    }

    protected void unbindUnitChangeMonitor(UnitChangeMonitor unitChangeMonitor) {
        if (this.unitChangeMonitor == unitChangeMonitor) {
            this.unitChangeMonitor = null;
        }
    }

    static enum AmbiguousPathSymbol {
        DASH(Character.valueOf('-')),
        UNDERSCORE(Character.valueOf('_'));

        private Character symbol;

        private AmbiguousPathSymbol(Character symbol) {
            this.symbol = symbol;
        }

        public Character getSymbol() {
            return this.symbol;
        }
    }

    class SightlyCompilationUnit
    extends SlingResourceCompilationUnit {
        private String fqcn;

        public SightlyCompilationUnit(Resource resource, String fqcn) {
            super(resource);
            this.fqcn = fqcn;
        }

        @Override
        public String getMainClassName() {
            return this.fqcn;
        }
    }

    class SlingResourceCompilationUnit
    implements CompilationUnit {
        private final Resource resource;

        public SlingResourceCompilationUnit(Resource resource) {
            this.resource = resource;
        }

        public Reader getSource() throws IOException {
            return new InputStreamReader((InputStream)this.resource.adaptTo(InputStream.class), "UTF-8");
        }

        public String getMainClassName() {
            return SightlyJavaCompilerService.this.getJavaNameFromPath(this.resource.getPath());
        }

        public long getLastModified() {
            return this.resource.getResourceMetadata().getModificationTime();
        }
    }
}

