/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.expression.node;

import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderContextImpl;
import org.apache.sling.scripting.sightly.render.RenderContext;

public enum BinaryOperator {
    AND{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            RenderContextImpl renderContextImpl = (RenderContextImpl)renderContext;
            return renderContextImpl.toBoolean(left) ? right : left;
        }
    }
    ,
    OR{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            RenderContextImpl renderContextImpl = (RenderContextImpl)renderContext;
            return renderContextImpl.toBoolean(left) ? left : right;
        }
    }
    ,
    CONCATENATE{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            RenderContextImpl renderContextImpl = (RenderContextImpl)renderContext;
            return renderContextImpl.toString(left).concat(renderContextImpl.toString(right));
        }
    }
    ,
    LT{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            return 4.lt(left, right);
        }
    }
    ,
    LEQ{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            return 5.leq(left, right);
        }
    }
    ,
    GT{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            return !6.leq(left, right);
        }
    }
    ,
    GEQ{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            return !7.lt(left, right);
        }
    }
    ,
    EQ{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            return BinaryOperator.eq(left, right);
        }
    }
    ,
    NEQ{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            return !BinaryOperator.eq(left, right);
        }
    }
    ,
    STRICT_EQ{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            return 10.strictEq(left, right);
        }
    }
    ,
    STRICT_NEQ{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            return !11.strictEq(left, right);
        }
    }
    ,
    ADD{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            RenderContextImpl renderContextImpl = (RenderContextImpl)renderContext;
            return BinaryOperator.adjust(renderContextImpl.toNumber(left).doubleValue() + renderContextImpl.toNumber(right).doubleValue());
        }
    }
    ,
    SUB{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            RenderContextImpl renderContextImpl = (RenderContextImpl)renderContext;
            return BinaryOperator.adjust(renderContextImpl.toNumber(left).doubleValue() - renderContextImpl.toNumber(right).doubleValue());
        }
    }
    ,
    MUL{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            RenderContextImpl renderContextImpl = (RenderContextImpl)renderContext;
            return BinaryOperator.adjust(renderContextImpl.toNumber(left).doubleValue() * renderContextImpl.toNumber(right).doubleValue());
        }
    }
    ,
    DIV{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            RenderContextImpl renderContextImpl = (RenderContextImpl)renderContext;
            return BinaryOperator.adjust(renderContextImpl.toNumber(left).doubleValue() / renderContextImpl.toNumber(right).doubleValue());
        }
    }
    ,
    I_DIV{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            RenderContextImpl renderContextImpl = (RenderContextImpl)renderContext;
            return BinaryOperator.adjust(renderContextImpl.toNumber(left).intValue() / renderContextImpl.toNumber(right).intValue());
        }
    }
    ,
    REM{

        @Override
        public Object eval(RenderContext renderContext, Object left, Object right) {
            RenderContextImpl renderContextImpl = (RenderContextImpl)renderContext;
            return BinaryOperator.adjust(renderContextImpl.toNumber(left).intValue() % renderContextImpl.toNumber(right).intValue());
        }
    };

    public static String OBJECT_NAME;
    public static String METHOD_STRICT_EQ;
    public static String METHOD_LEQ;
    public static String METHOD_LT;

    private static boolean eq(Object left, Object right) {
        if (left == null) {
            return right == null;
        }
        return left.equals(right);
    }

    public static boolean lt(Object left, Object right) {
        if (left instanceof Number && right instanceof Number) {
            return ((Number)left).doubleValue() < ((Number)right).doubleValue();
        }
        throw new UnsupportedOperationException("Invalid types in comparison. Comparison is supported for Number types only");
    }

    public static boolean leq(Object left, Object right) {
        if (left instanceof Number && right instanceof Number) {
            return ((Number)left).doubleValue() <= ((Number)right).doubleValue();
        }
        throw new UnsupportedOperationException("Invalid types in comparison. Comparison is supported for Number types only");
    }

    public static boolean strictEq(Object left, Object right) {
        if (left instanceof Number && right instanceof Number) {
            return ((Number)left).doubleValue() == ((Number)right).doubleValue();
        }
        if (left instanceof String && right instanceof String) {
            return left.equals(right);
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            return left.equals(right);
        }
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            Object notNull;
            Object object = notNull = left != null ? left : right;
            if (notNull instanceof String || notNull instanceof Boolean || notNull instanceof Number) {
                return false;
            }
        }
        throw new UnsupportedOperationException("Invalid types in comparison. Equality is supported for String, Number & Boolean types");
    }

    private static Number adjust(double x) {
        if (Math.floor(x) == x) {
            return (int)x;
        }
        return x;
    }

    public abstract Object eval(RenderContext var1, Object var2, Object var3);

    static {
        OBJECT_NAME = BinaryOperator.class.getName();
        METHOD_STRICT_EQ = "strictEq";
        METHOD_LEQ = "leq";
        METHOD_LT = "lt";
    }
}

