/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.expression.node;

import org.apache.sling.scripting.sightly.impl.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.Atom;

public class NumericConstant
implements Atom {
    public static final NumericConstant ZERO = new NumericConstant(0);
    public static final NumericConstant ONE = new NumericConstant(1);
    public static final NumericConstant TWO = new NumericConstant(2);
    private final String text;
    private final Number value;

    public NumericConstant(String text) {
        this.text = text;
        this.value = this.parseNumber(text);
    }

    public NumericConstant(Number value) {
        this.value = value.longValue();
        this.text = value.toString();
    }

    public Number getValue() {
        return this.value;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.evaluate(this);
    }

    public String toString() {
        return "NumericConstant{text='" + this.text + '\'' + '}';
    }

    private Number parseNumber(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return Double.parseDouble(s);
        }
    }
}

