/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.frontend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.scripting.sightly.impl.compiler.CompilerFrontend;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.PushStream;
import org.apache.sling.scripting.sightly.impl.filter.Filter;
import org.apache.sling.scripting.sightly.impl.html.dom.HtmlParserService;
import org.apache.sling.scripting.sightly.impl.html.dom.MarkupHandler;
import org.apache.sling.scripting.sightly.impl.plugin.Plugin;

public class SimpleFrontend
implements CompilerFrontend {
    private final HtmlParserService htmlParserService;
    private final Map<String, Plugin> plugins = new HashMap<String, Plugin>();
    private final List<Filter> filters;

    public SimpleFrontend(HtmlParserService htmlParserService, Collection<Plugin> plugins, Collection<Filter> filters) {
        for (Plugin plugin : plugins) {
            this.plugins.put(plugin.name(), plugin);
        }
        this.filters = new ArrayList<Filter>(filters);
        this.htmlParserService = htmlParserService;
    }

    @Override
    public void compile(PushStream stream, String source) {
        MarkupHandler markupHandler = new MarkupHandler(stream, this.plugins, this.filters);
        this.htmlParserService.parse(source, markupHandler);
    }
}

