/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.optimization;

import java.util.Stack;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BooleanConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.NullLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.NumericConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.StreamTransformer;
import org.apache.sling.scripting.sightly.impl.compiler.ris.Command;
import org.apache.sling.scripting.sightly.impl.compiler.ris.CommandStream;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Conditional;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.VariableBinding;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.EmitterVisitor;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.Streams;
import org.apache.sling.scripting.sightly.impl.compiler.visitor.StatefulRangeIgnore;
import org.apache.sling.scripting.sightly.impl.compiler.visitor.StatefulVisitor;
import org.apache.sling.scripting.sightly.impl.compiler.visitor.TrackingVisitor;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderContextImpl;
import org.apache.sling.scripting.sightly.render.RenderContext;

public class DeadCodeRemoval
extends TrackingVisitor<Boolean>
implements EmitterVisitor {
    private final PushStream outStream = new PushStream();
    private final StatefulVisitor.StateControl stateControl;
    private final RenderContextImpl renderContext;
    private final Stack<Boolean> keepConditionalEndStack = new Stack();

    public static StreamTransformer transformer(final RenderContext renderContext) {
        return new StreamTransformer(){

            @Override
            public CommandStream transform(CommandStream inStream) {
                StatefulVisitor visitor = new StatefulVisitor();
                DeadCodeRemoval dcr = new DeadCodeRemoval(visitor.getControl(), renderContext);
                visitor.initializeWith(dcr);
                Streams.connect(inStream, dcr.getOutputStream(), visitor);
                return dcr.getOutputStream();
            }
        };
    }

    public DeadCodeRemoval(StatefulVisitor.StateControl stateControl, RenderContext renderContext) {
        this.stateControl = stateControl;
        this.renderContext = (RenderContextImpl)renderContext;
    }

    @Override
    public void visit(VariableBinding.Start variableBindingStart) {
        Boolean truthValue = this.decodeConstantBool(variableBindingStart.getExpression());
        this.tracker.pushVariable(variableBindingStart.getVariableName(), truthValue);
        this.outStream.emit(variableBindingStart);
    }

    @Override
    public void visit(Conditional.Start conditionalStart) {
        boolean keepConditionalEnd;
        Boolean truthValue = (Boolean)this.tracker.get(conditionalStart.getVariable());
        if (truthValue == null) {
            keepConditionalEnd = true;
            this.outStream.emit(conditionalStart);
        } else {
            keepConditionalEnd = false;
            if (truthValue.booleanValue() != conditionalStart.getExpectedTruthValue()) {
                this.stateControl.push(new StatefulRangeIgnore(this.stateControl, Conditional.Start.class, Conditional.End.class));
                return;
            }
        }
        this.keepConditionalEndStack.push(keepConditionalEnd);
    }

    @Override
    public void visit(Conditional.End conditionalEnd) {
        boolean keep = this.keepConditionalEndStack.pop();
        if (keep) {
            this.outStream.emit(conditionalEnd);
        }
    }

    @Override
    public PushStream getOutputStream() {
        return this.outStream;
    }

    @Override
    protected Boolean assignDefault(Command command) {
        return null;
    }

    @Override
    protected void onCommand(Command command) {
        this.outStream.emit(command);
    }

    private Boolean decodeConstantBool(ExpressionNode node) {
        if (node instanceof StringConstant) {
            return this.renderContext.toBoolean(((StringConstant)node).getText());
        }
        if (node instanceof BooleanConstant) {
            return ((BooleanConstant)node).getValue();
        }
        if (node instanceof NumericConstant) {
            return this.renderContext.toBoolean(((NumericConstant)node).getValue());
        }
        if (node instanceof NullLiteral) {
            return this.renderContext.toBoolean(null);
        }
        return null;
    }
}

