/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.optimization.reduce;

import java.util.Collection;
import java.util.Map;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.StreamTransformer;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.reduce.EvalResult;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.reduce.ExpressionReducer;
import org.apache.sling.scripting.sightly.impl.compiler.ris.Command;
import org.apache.sling.scripting.sightly.impl.compiler.ris.CommandStream;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.VariableBinding;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.EmitterVisitor;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.Streams;
import org.apache.sling.scripting.sightly.impl.compiler.visitor.TrackingVisitor;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderContextImpl;

public final class ConstantFolding
extends TrackingVisitor<EvalResult>
implements EmitterVisitor {
    private final RenderContextImpl renderContext;
    private final PushStream outStream = new PushStream();

    private ConstantFolding(RenderContextImpl renderContext) {
        this.renderContext = renderContext;
    }

    public static StreamTransformer transformer(final RenderContextImpl renderContext) {
        return new StreamTransformer(){

            @Override
            public CommandStream transform(CommandStream inStream) {
                return Streams.map(inStream, new ConstantFolding(renderContext));
            }
        };
    }

    @Override
    public void visit(VariableBinding.Start variableBindingStart) {
        String variable = variableBindingStart.getVariableName();
        ExpressionNode node = variableBindingStart.getExpression();
        EvalResult result = ExpressionReducer.reduce(node, this.tracker, this.renderContext);
        result = this.avoidFoldingDataStructures(result);
        this.tracker.pushVariable(variable, result);
        this.outStream.emit(new VariableBinding.Start(variable, result.getNode()));
    }

    private EvalResult avoidFoldingDataStructures(EvalResult evalResult) {
        if (evalResult.isConstant() && this.isDataStructure(evalResult.getValue())) {
            return EvalResult.nonConstant(evalResult.getNode());
        }
        return evalResult;
    }

    private boolean isDataStructure(Object obj) {
        return obj instanceof Collection || obj instanceof Map;
    }

    @Override
    protected EvalResult assignDefault(Command command) {
        return null;
    }

    @Override
    protected void onCommand(Command command) {
        this.outStream.emit(command);
    }

    @Override
    public PushStream getOutputStream() {
        return this.outStream;
    }
}

