/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={UnitChangeMonitor.class})
public class UnitChangeMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(UnitChangeMonitor.class);
    private Map<String, Long> slyScriptsMap = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> slySourcesMap = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> slyJavaUseMap = new ConcurrentHashMap<String, Long>();
    private ServiceRegistration eventHandlerServiceRegistration;
    private String[] searchPaths;
    @Reference
    private ResourceResolverFactory rrf = null;
    @Reference
    private SlingSettingsService slingSettings = null;

    public long getLastModifiedDateForScript(String script) {
        if (script == null) {
            return 0L;
        }
        Long date = this.slyScriptsMap.get(script);
        return date != null ? date : 0L;
    }

    public long getLastModifiedDateForJavaSourceFile(String file) {
        if (file == null) {
            return 0L;
        }
        Long date = this.slySourcesMap.get(file);
        return date != null ? date : 0L;
    }

    public long getLastModifiedDateForJavaUseObject(String path) {
        if (path == null) {
            return 0L;
        }
        Long date = this.slyJavaUseMap.get(path);
        return date != null ? date : 0L;
    }

    public void touchScript(String script) {
        this.slyScriptsMap.put(script, System.currentTimeMillis());
    }

    public void clearJavaUseObject(String path) {
        if (path != null) {
            this.slyJavaUseMap.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext componentContext) {
        ResourceResolver adminResolver = null;
        try {
            adminResolver = this.rrf.getAdministrativeResourceResolver(null);
            StringBuilder eventHandlerFilteredPaths = new StringBuilder("(|");
            for (String sp : this.searchPaths = adminResolver.getSearchPath()) {
                eventHandlerFilteredPaths.append("(path=").append(sp).append("**/*.").append("html").append(")");
                eventHandlerFilteredPaths.append("(path=").append(sp).append("**/*.java").append(")");
            }
            String basePath = "/var/classes/" + this.slingSettings.getSlingId() + "/sightly/";
            eventHandlerFilteredPaths.append("(path=").append(basePath).append("**/*.java))");
            Hashtable<String, Object> eventHandlerProperties = new Hashtable<String, Object>();
            ((Dictionary)eventHandlerProperties).put("event.filter", eventHandlerFilteredPaths.toString());
            ((Dictionary)eventHandlerProperties).put("event.topics", new String[]{"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/CHANGED", "org/apache/sling/api/resource/Resource/REMOVED"});
            this.eventHandlerServiceRegistration = componentContext.getBundleContext().registerService(EventHandler.class.getName(), (Object)new EventHandler(){

                public void handleEvent(Event event) {
                    UnitChangeMonitor.this.processEvent(event);
                }
            }, eventHandlerProperties);
        }
        catch (LoginException e) {
            LOG.error("Unable to listen for change events.", (Throwable)e);
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        if (this.eventHandlerServiceRegistration != null) {
            this.eventHandlerServiceRegistration.unregister();
        }
    }

    private void processEvent(Event event) {
        String path = (String)event.getProperty("path");
        String topic = event.getTopic();
        if ("org/apache/sling/api/resource/Resource/ADDED".equals(topic) || "org/apache/sling/api/resource/Resource/CHANGED".equals(topic)) {
            if (path.startsWith("/var/classes")) {
                this.slySourcesMap.put(path, System.currentTimeMillis());
            } else if (path.endsWith(".java")) {
                this.slyJavaUseMap.put(path, System.currentTimeMillis());
            } else if (path.endsWith("html")) {
                this.slyScriptsMap.put(path, System.currentTimeMillis());
            }
        } else if ("org/apache/sling/api/resource/Resource/REMOVED".equals(topic)) {
            if (path.startsWith("/var/classes")) {
                this.slySourcesMap.remove(path);
            } else if (path.endsWith(".java")) {
                this.slyJavaUseMap.remove(path);
            } else if (path.endsWith("html")) {
                this.slyScriptsMap.remove(path);
            }
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    protected void bindSlingSettings(SlingSettingsService slingSettingsService) {
        this.slingSettings = slingSettingsService;
    }

    protected void unbindSlingSettings(SlingSettingsService slingSettingsService) {
        if (this.slingSettings == slingSettingsService) {
            this.slingSettings = null;
        }
    }
}

