/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.script.Bindings;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.impl.compiled.CompilationOutput;
import org.apache.sling.scripting.sightly.impl.compiled.JavaClassBackend;
import org.apache.sling.scripting.sightly.impl.compiler.SightlyCompilerService;
import org.apache.sling.scripting.sightly.impl.compiler.SightlyJavaCompilerService;
import org.apache.sling.scripting.sightly.impl.compiler.SightlyParsingException;
import org.apache.sling.scripting.sightly.impl.compiler.util.GlobalShadowCheckBackend;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.engine.UnitChangeMonitor;
import org.apache.sling.scripting.sightly.impl.engine.compiled.JavaClassTemplate;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SourceIdentifier;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderContextImpl;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderUnit;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={UnitLoader.class})
public class UnitLoader {
    public static final String DEFAULT_REPO_BASE_PATH = "/var/classes";
    public static final String CLASS_NAME_PREFIX = "SightlyJava_";
    private static final Logger log = LoggerFactory.getLogger(UnitLoader.class);
    private static final String MAIN_TEMPLATE_PATH = "templates/compiled_unit_template.txt";
    private static final String CHILD_TEMPLATE_PATH = "templates/subtemplate.txt";
    private static final String NT_FOLDER = "nt:folder";
    private static final String NT_FILE = "nt:file";
    private static final String NT_RESOURCE = "nt:resource";
    private static final String JCR_PRIMARY_TYPE = "jcr:primaryType";
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_DATA = "jcr:data";
    private static final String JCR_LASTMODIFIED = "jcr:lastModified";
    private String mainTemplate;
    private String childTemplate;
    private final Map<String, Lock> activeWrites = new HashMap<String, Lock>();
    @Reference
    private SightlyCompilerService sightlyCompilerService = null;
    @Reference
    private SightlyJavaCompilerService sightlyJavaCompilerService = null;
    @Reference
    private SightlyEngineConfiguration sightlyEngineConfiguration = null;
    @Reference
    private ResourceResolverFactory rrf = null;
    @Reference
    private SlingSettingsService slingSettings = null;
    @Reference
    private UnitChangeMonitor unitChangeMonitor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderUnit createUnit(Resource scriptResource, Bindings bindings, RenderContextImpl renderContext) {
        Lock lock = null;
        try {
            Object obj;
            Object object;
            SourceIdentifier sourceIdentifier = this.obtainIdentifier(scriptResource);
            ResourceMetadata resourceMetadata = scriptResource.getResourceMetadata();
            String encoding = resourceMetadata.getCharacterEncoding();
            if (encoding == null) {
                encoding = this.sightlyEngineConfiguration.getEncoding();
            }
            SlingHttpServletResponse response = (SlingHttpServletResponse)bindings.get("response");
            response.setCharacterEncoding(encoding);
            ResourceResolver adminResolver = renderContext.getScriptResourceResolver();
            if (this.needsUpdate(sourceIdentifier)) {
                object = this.activeWrites;
                synchronized (object) {
                    String sourceFullPath = sourceIdentifier.getSourceFullPath();
                    lock = this.activeWrites.get(sourceFullPath);
                    if (lock == null) {
                        lock = new ReentrantLock();
                        this.activeWrites.put(sourceFullPath, lock);
                    }
                    lock.lock();
                }
                Resource javaClassResource = this.createClass(adminResolver, sourceIdentifier, bindings, encoding, renderContext);
                obj = this.sightlyJavaCompilerService.compileSource(javaClassResource, sourceIdentifier.getFullyQualifiedName());
            } else {
                obj = this.sightlyJavaCompilerService.getInstance(adminResolver, null, sourceIdentifier.getFullyQualifiedName());
            }
            if (!(obj instanceof RenderUnit)) {
                throw new SightlyException("Class is not a RenderUnit instance");
            }
            object = (RenderUnit)obj;
            return object;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext componentContext) {
        this.mainTemplate = this.resourceFile(componentContext, MAIN_TEMPLATE_PATH);
        this.childTemplate = this.resourceFile(componentContext, CHILD_TEMPLATE_PATH);
        String basePath = "/var/classes/" + this.slingSettings.getSlingId() + "/sightly/";
        ResourceResolver adminResolver = null;
        try {
            adminResolver = this.rrf.getAdministrativeResourceResolver(null);
            Resource basePathResource = adminResolver.getResource(basePath);
            if (basePathResource != null) {
                for (Resource resource : basePathResource.getChildren()) {
                    if (resource.getName().equals(this.sightlyEngineConfiguration.getEngineVersion())) continue;
                    adminResolver.delete(resource);
                }
                if (adminResolver.hasChanges()) {
                    adminResolver.commit();
                }
            }
        }
        catch (Exception e) {
            log.error("Cannot delete stale Sightly Java classes.", (Throwable)e);
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
    }

    private synchronized Resource writeSource(ResourceResolver resolver, String sourceFullPath, String source) {
        Resource sourceResource;
        try {
            String sourceParentPath = ResourceUtil.getParent((String)sourceFullPath);
            HashMap<String, Object> sourceFolderProperties = new HashMap<String, Object>();
            sourceFolderProperties.put(JCR_PRIMARY_TYPE, NT_FOLDER);
            this.createResource(resolver, sourceParentPath, sourceFolderProperties, NT_FOLDER, true, false);
            HashMap<String, Object> sourceFileProperties = new HashMap<String, Object>();
            sourceFileProperties.put(JCR_PRIMARY_TYPE, NT_FILE);
            sourceResource = this.createResource(resolver, sourceFullPath, sourceFileProperties, null, false, false);
            HashMap<String, Object> ntResourceProperties = new HashMap<String, Object>();
            ntResourceProperties.put(JCR_PRIMARY_TYPE, NT_RESOURCE);
            ntResourceProperties.put(JCR_DATA, new ByteArrayInputStream(source.getBytes()));
            ntResourceProperties.put(JCR_LASTMODIFIED, Calendar.getInstance());
            this.createResource(resolver, sourceFullPath + "/" + JCR_CONTENT, ntResourceProperties, NT_RESOURCE, true, true);
            log.debug("Successfully written Java source file to repository: {}", (Object)sourceFullPath);
        }
        catch (PersistenceException e) {
            throw new SightlyException("Repository error while writing Java source file: " + sourceFullPath, e);
        }
        return sourceResource;
    }

    private SourceIdentifier obtainIdentifier(Resource resource) {
        String basePath = "/var/classes/" + this.slingSettings.getSlingId() + "/sightly/" + this.sightlyEngineConfiguration.getEngineVersion();
        return new SourceIdentifier(resource, CLASS_NAME_PREFIX, basePath);
    }

    private Resource createClass(ResourceResolver resolver, SourceIdentifier identifier, Bindings bindings, String encoding, RenderContextImpl renderContext) {
        String scriptSource = null;
        try {
            Resource scriptResource = resolver.getResource(identifier.getResource().getPath());
            if (scriptResource != null) {
                scriptSource = IOUtils.toString((InputStream)((InputStream)scriptResource.adaptTo(InputStream.class)), (String)encoding);
                String javaSourceCode = this.obtainResultSource(scriptSource, identifier, bindings, renderContext);
                return this.writeSource(resolver, identifier.getSourceFullPath(), javaSourceCode);
            }
        }
        catch (SightlyParsingException e) {
            String offendingInput = e.getOffendingInput();
            if (StringUtils.isNotEmpty((String)offendingInput)) {
                offendingInput = StringEscapeUtils.unescapeHtml((String)offendingInput.trim());
                int errorLine = this.getLineWhereErrorOccurred(scriptSource, offendingInput);
                throw new SightlyException("Parsing error in template " + identifier.getResource().getPath() + " at line " + errorLine + ": " + e.getMessage() + " for expression " + offendingInput);
            }
            throw e;
        }
        catch (IOException e) {
            throw new SightlyException(e);
        }
        throw new SightlyException("Unable to generate Java class for template " + identifier.getResource().getPath());
    }

    private String obtainResultSource(String scriptSource, SourceIdentifier identifier, Bindings bindings, RenderContextImpl renderContext) {
        JavaClassTemplate classTemplate = this.newMainTemplate();
        classTemplate.setClassName(identifier.getClassName());
        classTemplate.setPackageName(identifier.getPackageName());
        CompilationOutput compilationOutput = this.obtainOutput(scriptSource, bindings, renderContext);
        this.processCompilationResult(compilationOutput, classTemplate);
        return classTemplate.toString();
    }

    private CompilationOutput obtainOutput(String source, Bindings bindings, RenderContextImpl renderContext) {
        JavaClassBackend backend = new JavaClassBackend();
        this.sightlyCompilerService.compile(source, new GlobalShadowCheckBackend(backend, bindings.keySet()), renderContext);
        return backend.build();
    }

    private void processCompilationResult(CompilationOutput result, JavaClassTemplate mainTemplate) {
        mainTemplate.writeMainBody(result.getMainBody());
        for (Map.Entry<String, CompilationOutput> entry : result.getSubTemplates().entrySet()) {
            JavaClassTemplate childTemplate = this.newChildTemplate();
            this.processCompilationResult(entry.getValue(), childTemplate);
            mainTemplate.writeSubTemplate(entry.getKey(), childTemplate.toString());
        }
    }

    private JavaClassTemplate newMainTemplate() {
        return new JavaClassTemplate(this.mainTemplate);
    }

    private JavaClassTemplate newChildTemplate() {
        return new JavaClassTemplate(this.childTemplate);
    }

    private String resourceFile(ComponentContext componentContext, String path) {
        InputStream inputStream = null;
        try {
            URL url = componentContext.getBundleContext().getBundle().getEntry(path);
            if (url == null) {
                throw new SightlyException("No bundle resource resides at " + path);
            }
            inputStream = componentContext.getBundleContext().getBundle().getEntry(path).openStream();
            String string = IOUtils.toString((InputStream)inputStream);
            return string;
        }
        catch (IOException e) {
            throw new SightlyException("Java class templates could not be found");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("Error when closing bundle resource stream", (Throwable)e);
                }
            }
        }
    }

    private int getLineWhereErrorOccurred(String documentFragment, String offendingInput) {
        int offendingInputIndex = documentFragment.indexOf(offendingInput);
        String textBeforeError = documentFragment.substring(0, offendingInputIndex);
        int line = 0;
        int newLine = 0;
        while (textBeforeError.length() > 0 && newLine != -1) {
            newLine = textBeforeError.indexOf("\n");
            if (newLine == -1) continue;
            ++line;
            textBeforeError = textBeforeError.substring(newLine + 1, textBeforeError.length());
        }
        return ++line;
    }

    private boolean needsUpdate(SourceIdentifier sourceIdentifier) {
        if (this.sightlyEngineConfiguration.isDevMode()) {
            return true;
        }
        String slyPath = sourceIdentifier.getResource().getPath();
        long javaFileDate = this.unitChangeMonitor.getLastModifiedDateForJavaSourceFile(sourceIdentifier.getSourceFullPath());
        if (javaFileDate != 0L) {
            long slyScriptChangeDate = this.unitChangeMonitor.getLastModifiedDateForScript(slyPath);
            if (slyScriptChangeDate != 0L) {
                if (slyScriptChangeDate < javaFileDate) {
                    return false;
                }
            } else {
                this.unitChangeMonitor.touchScript(slyPath);
            }
            return true;
        }
        this.unitChangeMonitor.touchScript(slyPath);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource createResource(ResourceResolver resolver, String path, Map<String, Object> resourceProperties, String intermediateType, boolean autoCommit, boolean forceOverwrite) throws PersistenceException {
        Resource rsrc = resolver.getResource(path);
        if (rsrc == null || forceOverwrite) {
            Resource resource;
            Resource parentResource;
            int lastPos = path.lastIndexOf(47);
            String name = path.substring(lastPos + 1);
            if (lastPos == 0) {
                parentResource = resolver.getResource("/");
            } else {
                String parentPath = path.substring(0, lastPos);
                HashMap<String, Object> parentProperties = new HashMap<String, Object>();
                parentProperties.put(JCR_PRIMARY_TYPE, intermediateType);
                parentResource = this.createResource(resolver, parentPath, parentProperties, intermediateType, autoCommit, false);
            }
            if (autoCommit) {
                resolver.refresh();
            }
            if (forceOverwrite && (resource = resolver.getResource(parentResource, name)) != null) {
                resolver.delete(resource);
            }
            try {
                rsrc = resolver.create(parentResource, name, resourceProperties);
                if (autoCommit) {
                    resolver.commit();
                    resolver.refresh();
                    rsrc = resolver.getResource(parentResource, name);
                }
            }
            catch (PersistenceException pe) {
                resolver.revert();
                resolver.refresh();
                rsrc = resolver.getResource(parentResource, name);
                if (rsrc == null) {
                    rsrc = resolver.create(parentResource, name, resourceProperties);
                }
            }
            finally {
                if (autoCommit) {
                    resolver.commit();
                    resolver.refresh();
                    rsrc = resolver.getResource(parentResource, name);
                }
            }
        }
        return rsrc;
    }

    protected void bindSightlyCompilerService(SightlyCompilerService sightlyCompilerService) {
        this.sightlyCompilerService = sightlyCompilerService;
    }

    protected void unbindSightlyCompilerService(SightlyCompilerService sightlyCompilerService) {
        if (this.sightlyCompilerService == sightlyCompilerService) {
            this.sightlyCompilerService = null;
        }
    }

    protected void bindSightlyJavaCompilerService(SightlyJavaCompilerService sightlyJavaCompilerService) {
        this.sightlyJavaCompilerService = sightlyJavaCompilerService;
    }

    protected void unbindSightlyJavaCompilerService(SightlyJavaCompilerService sightlyJavaCompilerService) {
        if (this.sightlyJavaCompilerService == sightlyJavaCompilerService) {
            this.sightlyJavaCompilerService = null;
        }
    }

    protected void bindSightlyEngineConfiguration(SightlyEngineConfiguration sightlyEngineConfiguration) {
        this.sightlyEngineConfiguration = sightlyEngineConfiguration;
    }

    protected void unbindSightlyEngineConfiguration(SightlyEngineConfiguration sightlyEngineConfiguration) {
        if (this.sightlyEngineConfiguration == sightlyEngineConfiguration) {
            this.sightlyEngineConfiguration = null;
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    protected void bindSlingSettings(SlingSettingsService slingSettingsService) {
        this.slingSettings = slingSettingsService;
    }

    protected void unbindSlingSettings(SlingSettingsService slingSettingsService) {
        if (this.slingSettings == slingSettingsService) {
            this.slingSettings = null;
        }
    }

    protected void bindUnitChangeMonitor(UnitChangeMonitor unitChangeMonitor) {
        this.unitChangeMonitor = unitChangeMonitor;
    }

    protected void unbindUnitChangeMonitor(UnitChangeMonitor unitChangeMonitor) {
        if (this.unitChangeMonitor == unitChangeMonitor) {
            this.unitChangeMonitor = null;
        }
    }
}

