/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.compiled;

import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;

public class SourceIdentifier {
    private final String className;
    private final Resource resource;
    private final String packageName;
    private final String sourceFileName;
    private final String sourceFullPath;
    private final String fullyQualifiedName;

    public SourceIdentifier(Resource resource, String classNamePrefix, String basePath) {
        this.resource = resource;
        this.className = this.buildClassName(resource, classNamePrefix);
        this.packageName = this.buildPackageName(resource);
        this.sourceFileName = this.buildSourceFileName(this.className);
        this.sourceFullPath = this.buildSourceFullPath(resource, basePath, this.sourceFileName);
        this.fullyQualifiedName = this.buildFullyQualifiedName(this.packageName, this.className);
    }

    public String getClassName() {
        return this.className;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String getSourceFullPath() {
        return this.sourceFullPath;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    private String buildFullyQualifiedName(String packageName, String className) {
        return packageName + "." + className;
    }

    private String buildClassName(Resource resource, String classNamePrefix) {
        String scriptName = ResourceUtil.getName((String)resource.getPath());
        scriptName = scriptName.substring(0, scriptName.lastIndexOf(this.getExtension(scriptName)));
        String className = classNamePrefix + scriptName;
        return className.replaceAll("-", "_").replaceAll("\\.", "_");
    }

    private String buildPackageName(Resource resource) {
        return ResourceUtil.getParent((String)resource.getPath()).replaceAll("/", ".").substring(1).replaceAll("-", "_");
    }

    private String buildSourceFileName(String className) {
        return className + ".java";
    }

    private String buildSourceFullPath(Resource resource, String basePath, String sourceFileName) {
        String sourceParentPath = basePath + ResourceUtil.getParent((String)resource.getPath());
        return sourceParentPath + "/" + sourceFileName;
    }

    private String getExtension(String scriptName) {
        if (StringUtils.isEmpty((String)scriptName)) {
            return null;
        }
        int lastDotIndex = scriptName.lastIndexOf(46);
        return scriptName.substring(lastDotIndex);
    }
}

