/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.script.Bindings;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.compiler.CompilerException;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderContextImpl;
import org.apache.sling.scripting.sightly.impl.html.MarkupUtils;
import org.apache.sling.scripting.sightly.impl.plugin.MarkupContext;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.xss.XSSAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={RuntimeExtension.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.extension.name", value={"xss"})})
public class XSSRuntimeExtension
implements RuntimeExtension {
    private static final Set<String> elementNameWhiteList = new HashSet<String>();
    private static final Logger LOG = LoggerFactory.getLogger(XSSRuntimeExtension.class);
    private static final Pattern VALID_ATTRIBUTE = Pattern.compile("^[a-zA-Z_:][\\-a-zA-Z0-9_:\\.]*$");

    @Override
    public Object call(RenderContext renderContext, Object ... arguments) {
        if (arguments.length < 2) {
            throw new SightlyException(String.format("Extension %s requires at least %d arguments", "xss", 2));
        }
        Object original = arguments[0];
        Object option = arguments[1];
        Object hint = null;
        if (arguments.length >= 3) {
            hint = arguments[2];
        }
        MarkupContext markupContext = null;
        if (option != null && option instanceof String) {
            String name = (String)option;
            markupContext = MarkupContext.lookup(name);
        }
        if (markupContext == MarkupContext.UNSAFE) {
            return original;
        }
        if (markupContext == null) {
            LOG.warn("Expression context {} is invalid, expression will be replaced by the empty string", option);
            return "";
        }
        RenderContextImpl renderContextImpl = (RenderContextImpl)renderContext;
        String text = renderContextImpl.toString(original);
        XSSAPI xssapi = this.obtainAPI(renderContext.getBindings());
        return this.applyXSSFilter(xssapi, text, hint, markupContext);
    }

    private String applyXSSFilter(XSSAPI xssapi, String text, Object hint, MarkupContext xssContext) {
        if (xssContext.equals((Object)MarkupContext.ATTRIBUTE) && hint instanceof String) {
            String attributeName = (String)hint;
            MarkupContext attrMarkupContext = this.getAttributeMarkupContext(attributeName);
            return this.applyXSSFilter(xssapi, text, attrMarkupContext);
        }
        return this.applyXSSFilter(xssapi, text, xssContext);
    }

    private String applyXSSFilter(XSSAPI xssapi, String text, MarkupContext xssContext) {
        switch (xssContext) {
            case ATTRIBUTE: {
                return xssapi.encodeForHTMLAttr(text);
            }
            case COMMENT: 
            case TEXT: {
                return xssapi.encodeForHTML(text);
            }
            case ATTRIBUTE_NAME: {
                return this.escapeAttributeName(text);
            }
            case NUMBER: {
                return xssapi.getValidLong(text, 0L).toString();
            }
            case URI: {
                return xssapi.getValidHref(text);
            }
            case SCRIPT_TOKEN: {
                return xssapi.getValidJSToken(text, "");
            }
            case STYLE_TOKEN: {
                return xssapi.getValidStyleToken(text, "");
            }
            case SCRIPT_STRING: {
                return xssapi.encodeForJSString(text);
            }
            case STYLE_STRING: {
                return xssapi.encodeForCSSString(text);
            }
            case SCRIPT_COMMENT: 
            case STYLE_COMMENT: {
                return xssapi.getValidMultiLineComment(text, "");
            }
            case ELEMENT_NAME: {
                return this.escapeElementName(text);
            }
            case HTML: {
                return xssapi.filterHTML(text);
            }
        }
        return text;
    }

    private String escapeElementName(String original) {
        if (elementNameWhiteList.contains((original = original.trim()).toLowerCase())) {
            return original;
        }
        return "";
    }

    private XSSAPI obtainAPI(Bindings bindings) {
        SlingHttpServletRequest request = (SlingHttpServletRequest)bindings.get("request");
        if (request == null) {
            throw new CompilerException("Cannot obtain request from bindings");
        }
        return (XSSAPI)request.adaptTo(XSSAPI.class);
    }

    private MarkupContext getAttributeMarkupContext(String attributeName) {
        if ("src".equalsIgnoreCase(attributeName) || "href".equalsIgnoreCase(attributeName)) {
            return MarkupContext.URI;
        }
        return MarkupContext.ATTRIBUTE;
    }

    private String escapeAttributeName(String attributeName) {
        if (attributeName == null) {
            return null;
        }
        if (this.matchPattern(VALID_ATTRIBUTE, attributeName = attributeName.trim()) && !MarkupUtils.isSensitiveAttribute(attributeName)) {
            return attributeName;
        }
        return null;
    }

    private boolean matchPattern(Pattern pattern, String str) {
        return pattern.matcher(str).matches();
    }

    static {
        elementNameWhiteList.add("section");
        elementNameWhiteList.add("nav");
        elementNameWhiteList.add("article");
        elementNameWhiteList.add("aside");
        elementNameWhiteList.add("h1");
        elementNameWhiteList.add("h2");
        elementNameWhiteList.add("h3");
        elementNameWhiteList.add("h4");
        elementNameWhiteList.add("h5");
        elementNameWhiteList.add("h6");
        elementNameWhiteList.add("header");
        elementNameWhiteList.add("footer");
        elementNameWhiteList.add("address");
        elementNameWhiteList.add("main");
        elementNameWhiteList.add("p");
        elementNameWhiteList.add("pre");
        elementNameWhiteList.add("blockquote");
        elementNameWhiteList.add("ul");
        elementNameWhiteList.add("ol");
        elementNameWhiteList.add("li");
        elementNameWhiteList.add("dl");
        elementNameWhiteList.add("dt");
        elementNameWhiteList.add("dd");
        elementNameWhiteList.add("figure");
        elementNameWhiteList.add("figcaption");
        elementNameWhiteList.add("div");
        elementNameWhiteList.add("a");
        elementNameWhiteList.add("em");
        elementNameWhiteList.add("strong");
        elementNameWhiteList.add("small");
        elementNameWhiteList.add("s");
        elementNameWhiteList.add("cite");
        elementNameWhiteList.add("q");
        elementNameWhiteList.add("dfn");
        elementNameWhiteList.add("abbbr");
        elementNameWhiteList.add("data");
        elementNameWhiteList.add("time");
        elementNameWhiteList.add("code");
        elementNameWhiteList.add("var");
        elementNameWhiteList.add("samp");
        elementNameWhiteList.add("kbd");
        elementNameWhiteList.add("sub");
        elementNameWhiteList.add("sup");
        elementNameWhiteList.add("i");
        elementNameWhiteList.add("b");
        elementNameWhiteList.add("u");
        elementNameWhiteList.add("mark");
        elementNameWhiteList.add("ruby");
        elementNameWhiteList.add("rt");
        elementNameWhiteList.add("rp");
        elementNameWhiteList.add("bdi");
        elementNameWhiteList.add("bdo");
        elementNameWhiteList.add("span");
        elementNameWhiteList.add("br");
        elementNameWhiteList.add("wbr");
        elementNameWhiteList.add("ins");
        elementNameWhiteList.add("del");
        elementNameWhiteList.add("table");
        elementNameWhiteList.add("caption");
        elementNameWhiteList.add("colgroup");
        elementNameWhiteList.add("col");
        elementNameWhiteList.add("tbody");
        elementNameWhiteList.add("thead");
        elementNameWhiteList.add("tfoot");
        elementNameWhiteList.add("tr");
        elementNameWhiteList.add("td");
        elementNameWhiteList.add("th");
    }
}

