/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension.use;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.servlet.ServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.scripting.sightly.ResourceResolution;
import org.apache.sling.scripting.sightly.impl.compiler.SightlyJavaCompilerService;
import org.apache.sling.scripting.sightly.impl.engine.extension.use.UseProviderUtils;
import org.apache.sling.scripting.sightly.pojo.Use;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Sling Scripting Sightly Java Use Provider", description="The Java Use Provider is responsible for instantiating Java Use-API objects.")
@Service(value={UseProvider.class})
@Properties(value={@Property(name="service.ranking", label="Service Ranking", description="The Service Ranking value acts as the priority with which this Use Provider is queried to return an Use-object. A higher value represents a higher priority.", intValue={90}, propertyPrivate=false)})
public class JavaUseProvider
implements UseProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JavaUseProvider.class);
    private static final Pattern JAVA_PATTERN = Pattern.compile("([[\\p{L}&&[^\\p{Lu}]]_$][\\p{L}\\p{N}_$]*\\.)*[\\p{Lu}_$][\\p{L}\\p{N}_$]*");
    @Reference
    private SightlyJavaCompilerService sightlyJavaCompilerService = null;
    @Reference
    private DynamicClassLoaderManager dynamicClassLoaderManager = null;
    private static final Object NULL = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderOutcome provide(String identifier, RenderContext renderContext, Bindings arguments) {
        if (!JAVA_PATTERN.matcher(identifier).matches()) {
            LOG.debug("Identifier {} does not match a Java class name pattern.", (Object)identifier);
            return ProviderOutcome.failure();
        }
        Bindings globalBindings = renderContext.getBindings();
        Bindings bindings = UseProviderUtils.merge(globalBindings, arguments);
        SlingScriptHelper sling = UseProviderUtils.getHelper(bindings);
        Resource resource = (Resource)bindings.get("resource");
        SlingHttpServletRequest request = (SlingHttpServletRequest)bindings.get("request");
        Map<String, Object> overrides = this.setRequestAttributes((ServletRequest)request, arguments);
        try {
            Class<?> cls = this.dynamicClassLoaderManager.getDynamicClassLoader().loadClass(identifier);
            Object result = resource.adaptTo(cls);
            if (result == null) {
                result = request.adaptTo(cls);
            }
            if (result != null) {
                ProviderOutcome providerOutcome = ProviderOutcome.success(result);
                return providerOutcome;
            }
            result = cls.newInstance();
            if (result instanceof Use) {
                ((Use)result).init(bindings);
            }
            ProviderOutcome providerOutcome = ProviderOutcome.notNullOrFailure(result);
            return providerOutcome;
        }
        catch (ClassNotFoundException e) {
            ProviderOutcome providerOutcome = this.getPOJOFromRepository(renderContext, sling, identifier, bindings);
            return providerOutcome;
        }
        catch (Exception e) {
            ProviderOutcome providerOutcome = ProviderOutcome.failure(e);
            return providerOutcome;
        }
        finally {
            this.resetRequestAttribute((ServletRequest)request, overrides);
        }
    }

    private ProviderOutcome getPOJOFromRepository(RenderContext renderContext, SlingScriptHelper sling, String identifier, Bindings bindings) {
        try {
            ResourceResolver adminResolver = renderContext.getScriptResourceResolver();
            Resource resource = ResourceResolution.getResourceForRequest(adminResolver, sling.getRequest());
            Object result = this.sightlyJavaCompilerService.getInstance(adminResolver, resource, identifier);
            if (result instanceof Use) {
                ((Use)result).init(bindings);
            }
            return ProviderOutcome.success(result);
        }
        catch (Exception e) {
            return ProviderOutcome.failure(e);
        }
    }

    private Map<String, Object> setRequestAttributes(ServletRequest request, Bindings arguments) {
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        for (Map.Entry entry : arguments.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Object oldValue = request.getAttribute(key);
            if (oldValue != null) {
                overrides.put(key, oldValue);
            } else {
                overrides.put(key, NULL);
            }
            request.setAttribute(key, value);
        }
        return overrides;
    }

    private void resetRequestAttribute(ServletRequest request, Map<String, Object> overrides) {
        for (Map.Entry<String, Object> entry : overrides.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == NULL) {
                request.removeAttribute(key);
                continue;
            }
            request.setAttribute(key, value);
        }
    }

    protected void bindSightlyJavaCompilerService(SightlyJavaCompilerService sightlyJavaCompilerService) {
        this.sightlyJavaCompilerService = sightlyJavaCompilerService;
    }

    protected void unbindSightlyJavaCompilerService(SightlyJavaCompilerService sightlyJavaCompilerService) {
        if (this.sightlyJavaCompilerService == sightlyJavaCompilerService) {
            this.sightlyJavaCompilerService = null;
        }
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.dynamicClassLoaderManager == dynamicClassLoaderManager) {
            this.dynamicClassLoaderManager = null;
        }
    }
}

