/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.scripting.sightly.Record;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.render.RenderContext;

public class RenderContextImpl
implements RenderContext {
    public static final String TO_STRING_METHOD = "toString";
    public static final String PROPERTY_ACCESS = "resolveProperty";
    public static final String COLLECTION_COERCE = "toCollection";
    public static final String NUMERIC_COERCE = "toNumber";
    public static final String STRING_COERCE = "toString";
    public static final String BOOLEAN_COERCE = "toBoolean";
    private final Bindings bindings;
    private final Map<String, RuntimeExtension> mapping;
    private final ResourceResolver scriptResourceResolver;
    private static final Set<Class<?>> primitiveClasses = RenderContextImpl.primitiveClasses();

    public RenderContextImpl(Bindings bindings, Map<String, RuntimeExtension> mapping, ResourceResolver scriptResourceResolver) {
        this.bindings = bindings;
        this.mapping = mapping;
        this.scriptResourceResolver = scriptResourceResolver;
    }

    @Override
    public ResourceResolver getScriptResourceResolver() {
        return this.scriptResourceResolver;
    }

    @Override
    public Bindings getBindings() {
        return this.bindings;
    }

    @Override
    public Object call(String functionName, Object ... arguments) {
        RuntimeExtension extension = this.mapping.get(functionName);
        if (extension == null) {
            throw new SightlyException("Runtime extension is not available: " + functionName);
        }
        return extension.call(this, arguments);
    }

    public Object resolveProperty(Object target, Object property) {
        if (property instanceof Number) {
            return this.getIndex(target, ((Number)property).intValue());
        }
        return this.getProperty(target, property);
    }

    public String toString(Object target) {
        return this.objectToString(target);
    }

    public boolean toBoolean(Object object) {
        return this.toBooleanInternal(object);
    }

    public Collection<Object> toCollection(Object object) {
        return this.obtainCollection(object);
    }

    public Map toMap(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object instanceof Record) {
            HashMap map = new HashMap();
            Record record = (Record)object;
            Set<String> properties = record.getPropertyNames();
            for (String property : properties) {
                map.put(property, record.getProperty(property));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    public Number toNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        return 0;
    }

    public boolean isCollection(Object target) {
        return target instanceof Collection || target instanceof Object[] || target instanceof Iterable || target instanceof Iterator;
    }

    private Collection<Object> obtainCollection(Object obj) {
        if (obj == null) {
            return Collections.emptyList();
        }
        if (obj instanceof Object[]) {
            return Arrays.asList((Object[])obj);
        }
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj instanceof Map) {
            return ((Map)obj).keySet();
        }
        if (obj instanceof Record) {
            return ((Record)obj).getPropertyNames();
        }
        if (obj instanceof Enumeration) {
            return Collections.list((Enumeration)obj);
        }
        if (obj instanceof Iterator) {
            return this.fromIterator((Iterator)obj);
        }
        if (obj instanceof Iterable) {
            Iterable iterable = (Iterable)obj;
            return this.fromIterator(iterable.iterator());
        }
        if (obj instanceof String || obj instanceof Number) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(obj);
            return list;
        }
        return Collections.emptyList();
    }

    private Collection<Object> fromIterator(Iterator<Object> iterator) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    private boolean toBooleanInternal(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return number.doubleValue() != 0.0;
        }
        String s = obj.toString().trim();
        if ("".equals(s)) {
            return false;
        }
        if ("true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s)) {
            return Boolean.parseBoolean(s);
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size() > 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).size() > 0;
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator().hasNext();
        }
        if (obj instanceof Iterator) {
            return ((Iterator)obj).hasNext();
        }
        if (obj instanceof Object[]) {
            return ((Object[])obj).length > 0;
        }
        return true;
    }

    private Object getProperty(Object target, Object propertyObj) {
        String property = this.toString(propertyObj);
        if (StringUtils.isEmpty((String)property)) {
            throw new IllegalArgumentException("Invalid property name");
        }
        if (target == null) {
            return null;
        }
        Object result = null;
        if (target instanceof Map) {
            result = this.getMapProperty((Map)target, property);
        }
        if (result == null && target instanceof Record) {
            result = ((Record)target).getProperty(property);
        }
        if (result == null) {
            result = this.getObjectProperty(target, property);
        }
        if (result == null && target instanceof Adaptable) {
            result = this.getValueMapProperty((ValueMap)((Adaptable)target).adaptTo(ValueMap.class), property);
        }
        return result;
    }

    private Object getIndex(Object obj, int index) {
        Map map;
        if (obj instanceof Map && (map = (Map)obj).containsKey(index)) {
            return map.get(index);
        }
        Collection<Object> collection = this.toCollection(obj);
        if (collection instanceof List) {
            return this.getIndexSafe((List)collection, index);
        }
        return null;
    }

    private Object getIndexSafe(List list, int index) {
        if (index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    private Object getValueMapProperty(ValueMap valueMap, String property) {
        if (valueMap == null) {
            return null;
        }
        return valueMap.get((Object)property);
    }

    private Object getMapProperty(Map map, String property) {
        return map.get(property);
    }

    private Object getObjectProperty(Object obj, String property) {
        try {
            return this.getObjectNoArgMethod(obj, property);
        }
        catch (NoSuchMethodException nsmex) {
            return this.getField(obj, property);
        }
    }

    private Object getField(Object obj, String property) {
        if (obj instanceof Object[] && "length".equals(property)) {
            return ((Object[])obj).length;
        }
        Class<?> cls = obj.getClass();
        try {
            Field field = cls.getDeclaredField(property);
            return field.get(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object getObjectNoArgMethod(Object obj, String property) throws NoSuchMethodException {
        Class<?> cls = obj.getClass();
        Method method = this.findMethod(cls, property);
        try {
            method = RenderContextImpl.extractMethodInheritanceChain(cls, method);
            return method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new SightlyException(e);
        }
    }

    private Method findMethod(Class<?> cls, String baseName) throws NoSuchMethodException {
        Method[] publicMethods = cls.getMethods();
        String capitalized = StringUtils.capitalize((String)baseName);
        for (Method m : publicMethods) {
            String methodName;
            if (m.getParameterTypes().length != 0 || !baseName.equals(methodName = m.getName()) && !("get" + capitalized).equals(methodName) && !("is" + capitalized).equals(methodName)) continue;
            if (!this.isMethodAllowed(m)) break;
            return m;
        }
        throw new NoSuchMethodException(baseName);
    }

    private boolean isMethodAllowed(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        return declaringClass != Object.class || "toString".equals(method.getName());
    }

    private String objectToString(Object obj) {
        String output = "";
        if (obj != null) {
            if (obj instanceof String) {
                output = (String)obj;
            } else if (this.isPrimitive(obj)) {
                output = obj.toString();
            } else {
                Collection<Object> col = this.obtainCollection(obj);
                if (col != null) {
                    output = this.collectionToString(col);
                }
            }
        }
        return output;
    }

    private boolean isPrimitive(Object obj) {
        return primitiveClasses.contains(obj.getClass());
    }

    private String collectionToString(Collection<?> col) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        for (Object o : col) {
            builder.append(prefix).append(this.objectToString(o));
            prefix = ",";
        }
        return builder.toString();
    }

    private static Set<Class<?>> primitiveClasses() {
        HashSet set = new HashSet();
        set.add(Boolean.class);
        set.add(Character.class);
        set.add(Byte.class);
        set.add(Short.class);
        set.add(Integer.class);
        set.add(Long.class);
        set.add(Float.class);
        set.add(Double.class);
        set.add(Void.class);
        return set;
    }

    private static Method extractMethodInheritanceChain(Class type, Method m) {
        Method mp;
        Class<?>[] inf;
        if (m == null || Modifier.isPublic(type.getModifiers())) {
            return m;
        }
        for (Class<?> iface : inf = type.getInterfaces()) {
            try {
                mp = iface.getMethod(m.getName(), m.getParameterTypes());
                mp = RenderContextImpl.extractMethodInheritanceChain(mp.getDeclaringClass(), mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        Class sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = RenderContextImpl.extractMethodInheritanceChain(mp.getDeclaringClass(), mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }
}

