/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.runtime;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.sightly.Record;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderContextImpl;
import org.apache.sling.scripting.sightly.render.RenderContext;

public abstract class RenderUnit
implements Record<RenderUnit> {
    private final Map<String, RenderUnit> subTemplates = new HashMap<String, RenderUnit>();
    private Map<String, RenderUnit> siblings;

    public final void render(RenderContext renderContext, Bindings arguments) {
        Bindings globalBindings = renderContext.getBindings();
        PrintWriter writer = (PrintWriter)globalBindings.get("out");
        this.render(writer, this.buildGlobalScope(globalBindings), new CaseInsensitiveBindings(arguments), (RenderContextImpl)renderContext);
    }

    @Override
    public RenderUnit getProperty(String name) {
        return this.subTemplates.get(name.toLowerCase());
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.subTemplates.keySet();
    }

    protected abstract void render(PrintWriter var1, Bindings var2, Bindings var3, RenderContextImpl var4);

    protected void callUnit(RenderContext renderContext, Object templateObj, Object argsObj) {
        if (!(templateObj instanceof RenderUnit)) {
            return;
        }
        RenderUnit unit = (RenderUnit)templateObj;
        RenderContextImpl renderContextImpl = (RenderContextImpl)renderContext;
        SlingScriptHelper ssh = (SlingScriptHelper)renderContextImpl.getBindings().get("sling");
        Map argumentsMap = renderContextImpl.toMap(argsObj);
        SimpleBindings arguments = new SimpleBindings(Collections.unmodifiableMap(argumentsMap));
        unit.render(renderContext, arguments);
    }

    protected FluentMap obj() {
        return new FluentMap();
    }

    protected final void addSubTemplate(String name, RenderUnit renderUnit) {
        renderUnit.setSiblings(this.subTemplates);
        this.subTemplates.put(name.toLowerCase(), renderUnit);
    }

    private void setSiblings(Map<String, RenderUnit> siblings) {
        this.siblings = siblings;
    }

    private Bindings buildGlobalScope(Bindings bindings) {
        SimpleBindings simpleBindings = new SimpleBindings(bindings);
        simpleBindings.putAll(bindings);
        if (this.siblings != null) {
            simpleBindings.putAll((Map<? extends String, ? extends Object>)this.siblings);
        }
        simpleBindings.putAll((Map<? extends String, ? extends Object>)this.subTemplates);
        return new CaseInsensitiveBindings(simpleBindings);
    }

    private static final class CaseInsensitiveBindings
    extends SimpleBindings {
        private CaseInsensitiveBindings(Map<String, Object> m) {
            for (Map.Entry<String, Object> entry : m.entrySet()) {
                this.put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }

        @Override
        public Object get(Object key) {
            if (!(key instanceof String)) {
                throw new ClassCastException("key should be a String");
            }
            return super.get(((String)key).toLowerCase());
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof String)) {
                throw new ClassCastException("key should be a String");
            }
            return super.containsKey(((String)key).toLowerCase());
        }
    }

    protected static class FluentMap
    extends HashMap<String, Object> {
        protected FluentMap() {
        }

        public FluentMap with(String name, Object value) {
            this.put(name, value);
            return this;
        }
    }
}

