/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.html.dom;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import org.apache.sling.scripting.sightly.impl.html.dom.DocumentHandler;
import org.apache.sling.scripting.sightly.impl.html.dom.TagTokenizer;

public final class HtmlParser {
    private static int BUF_SIZE = 2048;
    private final CharArrayWriter buffer = new CharArrayWriter(256);
    private final TagTokenizer tokenizer = new TagTokenizer();
    private final CharArrayWriter tagNameBuffer = new CharArrayWriter(30);
    private String tagName;
    private final DocumentHandler documentHandler;
    private static final int TT_NONE = 0;
    private static final int TT_MAYBE = 1;
    private static final int TT_TAG = 2;
    private static final int EXPR_NONE = 0;
    private static final int EXPR_MAYBE = 1;
    private PARSE_STATE parseState = PARSE_STATE.OUTSIDE;
    private int parseSubState;
    private PARSE_STATE prevParseState;
    private int tagType;
    private int exprType;
    private char quoteChar;

    public static void parse(Reader reader, DocumentHandler documentHandler) throws IOException {
        HtmlParser parser = new HtmlParser(documentHandler);
        parser.parse(reader);
    }

    private HtmlParser(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(Reader reader) throws IOException {
        try {
            this.documentHandler.onStart();
            char[] readBuffer = new char[BUF_SIZE];
            int readLen = 0;
            while ((readLen = reader.read(readBuffer)) > 0) {
                this.update(readBuffer, readLen);
            }
            this.flushBuffer();
            this.documentHandler.onEnd();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void update(char[] buf, int len) throws IOException {
        int start = 0;
        int end = len;
        block32: for (int curr = start; curr < end; ++curr) {
            char c = buf[curr];
            switch (this.parseState) {
                case OUTSIDE: {
                    if (c == '<') {
                        if (curr > start) {
                            this.documentHandler.onCharacters(buf, start, curr - start);
                        }
                        start = curr;
                        this.parseState = PARSE_STATE.TAG;
                        this.parseSubState = 0;
                        this.tagType = 1;
                        this.resetTagName();
                        continue block32;
                    }
                    if (c != '$') continue block32;
                    this.exprType = 1;
                    this.parseState = PARSE_STATE.EXPRESSION;
                    continue block32;
                }
                case TAG: {
                    switch (this.parseSubState) {
                        case -1: {
                            if (c == '\"' || c == '\'') {
                                this.quoteChar = c;
                                this.prevParseState = this.parseState;
                                this.parseState = PARSE_STATE.STRING;
                                this.parseSubState = -1;
                                break;
                            }
                            if (c != '>') break;
                            this.parseState = PARSE_STATE.OUTSIDE;
                            break;
                        }
                        case 0: {
                            if (c == '!') {
                                this.parseState = PARSE_STATE.COMMENT;
                                this.parseSubState = 0;
                                this.tagType = 0;
                                break;
                            }
                            if (c == '\"' || c == '\'') {
                                this.quoteChar = c;
                                this.prevParseState = this.parseState;
                                this.parseState = PARSE_STATE.STRING;
                                this.parseSubState = -1;
                                this.tagType = 0;
                                this.flushBuffer();
                                break;
                            }
                            if (c == '>') {
                                this.parseState = PARSE_STATE.OUTSIDE;
                                this.tagType = 0;
                                this.flushBuffer();
                                break;
                            }
                            if (!Character.isWhitespace(c)) {
                                this.tagNameBuffer.write(c);
                                this.parseSubState = 1;
                                break;
                            }
                            this.parseSubState = -1;
                            this.tagType = 0;
                            this.flushBuffer();
                            break;
                        }
                        case 1: {
                            if (c == '\"' || c == '\'') {
                                this.tagType = 2;
                                this.parseSubState = 2;
                                this.quoteChar = c;
                                this.prevParseState = this.parseState;
                                this.parseState = PARSE_STATE.STRING;
                                break;
                            }
                            if (c == '>') {
                                this.parseState = this.processTag(buf, start, curr - start + 1) ? PARSE_STATE.SCRIPT : PARSE_STATE.OUTSIDE;
                                start = curr + 1;
                                this.tagType = 0;
                                this.parseSubState = 0;
                                break;
                            }
                            if (Character.isWhitespace(c)) {
                                this.tagType = 2;
                                this.parseSubState = 2;
                                break;
                            }
                            this.tagNameBuffer.write(c);
                            break;
                        }
                        case 2: {
                            if (c == '\"' || c == '\'') {
                                this.quoteChar = c;
                                this.prevParseState = this.parseState;
                                this.parseState = PARSE_STATE.STRING;
                                break;
                            }
                            if (c != '>') break;
                            if (this.tagType == 2) {
                                this.parseState = this.processTag(buf, start, curr - start + 1) ? PARSE_STATE.SCRIPT : PARSE_STATE.OUTSIDE;
                                start = curr + 1;
                            } else {
                                this.flushBuffer();
                                this.parseState = "SCRIPT".equalsIgnoreCase(this.getTagName()) ? PARSE_STATE.SCRIPT : PARSE_STATE.OUTSIDE;
                            }
                            this.tagType = 0;
                            this.parseSubState = 0;
                        }
                    }
                    continue block32;
                }
                case COMMENT: {
                    switch (this.parseSubState) {
                        case 0: {
                            if (c == '-') {
                                ++this.parseSubState;
                                break;
                            }
                            if (c == '\"' || c == '\'') {
                                this.quoteChar = c;
                                this.prevParseState = PARSE_STATE.TAG;
                                this.parseState = PARSE_STATE.STRING;
                                this.parseSubState = -1;
                                this.tagType = 0;
                                this.flushBuffer();
                                break;
                            }
                            if (c == '>') {
                                this.parseState = PARSE_STATE.OUTSIDE;
                                this.tagType = 0;
                                this.flushBuffer();
                                break;
                            }
                            this.parseState = PARSE_STATE.TAG;
                            this.parseSubState = -1;
                            this.tagType = 0;
                            this.flushBuffer();
                            break;
                        }
                        case 1: {
                            if (c == '-') {
                                ++this.parseSubState;
                                break;
                            }
                            if (c == '\"' || c == '\'') {
                                this.quoteChar = c;
                                this.prevParseState = PARSE_STATE.TAG;
                                this.parseState = PARSE_STATE.STRING;
                                this.parseSubState = -1;
                                this.tagType = 0;
                                this.flushBuffer();
                                break;
                            }
                            if (c == '>') {
                                this.parseState = PARSE_STATE.OUTSIDE;
                                this.tagType = 0;
                                this.flushBuffer();
                                break;
                            }
                            this.parseState = PARSE_STATE.TAG;
                            this.parseSubState = -1;
                            this.tagType = 0;
                            this.flushBuffer();
                            break;
                        }
                        case 2: {
                            if (c != '-') break;
                            ++this.parseSubState;
                            break;
                        }
                        case 3: {
                            if (c == '-') {
                                ++this.parseSubState;
                                break;
                            }
                            this.parseSubState = 2;
                            break;
                        }
                        case 4: {
                            if (c == '>') {
                                this.parseState = PARSE_STATE.OUTSIDE;
                                this.processComment(buf, start, curr - start + 1);
                                start = curr + 1;
                                break;
                            }
                            this.parseSubState = 2;
                        }
                    }
                    continue block32;
                }
                case SCRIPT: {
                    switch (this.parseSubState) {
                        case 0: {
                            if (c != '<') break;
                            if (curr > start) {
                                this.documentHandler.onCharacters(buf, start, curr - start);
                            }
                            start = curr;
                            this.tagType = 1;
                            ++this.parseSubState;
                            break;
                        }
                        case 1: {
                            if (c == '/') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.parseSubState = 0;
                            this.flushBuffer();
                            break;
                        }
                        case 2: {
                            if (c == 'S' || c == 's') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.parseSubState = 0;
                            this.flushBuffer();
                            break;
                        }
                        case 3: {
                            if (c == 'C' || c == 'c') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.parseSubState = 0;
                            this.flushBuffer();
                            break;
                        }
                        case 4: {
                            if (c == 'R' || c == 'r') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.parseSubState = 0;
                            this.flushBuffer();
                            break;
                        }
                        case 5: {
                            if (c == 'I' || c == 'i') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.parseSubState = 0;
                            this.flushBuffer();
                            break;
                        }
                        case 6: {
                            if (c == 'P' || c == 'p') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.parseSubState = 0;
                            this.flushBuffer();
                            break;
                        }
                        case 7: {
                            if (c == 'T' || c == 't') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.parseSubState = 0;
                            this.flushBuffer();
                            break;
                        }
                        case 8: {
                            if (c != '>') break;
                            this.processTag(buf, start, curr - start + 1);
                            start = curr + 1;
                            this.tagType = 0;
                            this.parseState = PARSE_STATE.OUTSIDE;
                        }
                    }
                    continue block32;
                }
                case STRING: {
                    if (c != this.quoteChar) continue block32;
                    this.parseState = this.prevParseState;
                    continue block32;
                }
                case EXPRESSION: {
                    if (this.exprType == 1 && c != '{') {
                        if (c == '<') {
                            --curr;
                        }
                        this.parseState = PARSE_STATE.OUTSIDE;
                    } else if (c == '}') {
                        this.parseState = PARSE_STATE.OUTSIDE;
                    }
                    this.exprType = 0;
                }
            }
        }
        if (start < end) {
            if (this.tagType == 0 && this.parseState != PARSE_STATE.COMMENT) {
                this.documentHandler.onCharacters(buf, start, end - start);
            } else {
                this.buffer.write(buf, start, end - start);
            }
        }
    }

    private void resetTagName() {
        this.tagName = null;
        this.tagNameBuffer.reset();
    }

    private String getTagName() {
        if (this.tagName == null) {
            this.tagName = this.tagNameBuffer.toString();
        }
        return this.tagName;
    }

    private void flushBuffer() throws IOException {
        if (this.buffer.size() > 0) {
            char[] chars = this.buffer.toCharArray();
            this.documentHandler.onCharacters(chars, 0, chars.length);
            this.buffer.reset();
        }
    }

    private void processComment(char[] ch, int off, int len) throws IOException {
        this.buffer.write(ch, off, len);
        this.documentHandler.onComment(this.buffer.toString());
        this.buffer.reset();
    }

    private boolean processTag(char[] ch, int off, int len) throws IOException {
        this.buffer.write(ch, off, len);
        char[] snippet = this.buffer.toCharArray();
        this.tokenizer.tokenize(snippet, 0, snippet.length);
        if (!this.tokenizer.endTag()) {
            this.documentHandler.onStartElement(this.tokenizer.tagName(), this.tokenizer.attributes(), this.tokenizer.endSlash());
        } else {
            this.documentHandler.onEndElement(this.tokenizer.tagName());
        }
        this.buffer.reset();
        return "SCRIPT".equalsIgnoreCase(this.tokenizer.tagName()) && !this.tokenizer.endSlash();
    }

    private static enum PARSE_STATE {
        OUTSIDE,
        TAG,
        SCRIPT,
        COMMENT,
        STRING,
        EXPRESSION;

    }
}

