/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.impl.compiler.common.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.MapLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Patterns;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Procedure;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.VariableBinding;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.PushStream;
import org.apache.sling.scripting.sightly.impl.plugin.Plugin;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginComponent;
import org.apache.sling.scripting.sightly.impl.plugin.PluginException;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

@Component
@Service(value={Plugin.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.impl.plugin.name", value={"call"}), @Property(name="org.apache.sling.scripting.sightly.impl.plugin.priority", intValue={3})})
public class CallPlugin
extends PluginComponent {
    @Override
    public PluginInvoke invoke(final Expression expression, PluginCallInfo callInfo, final CompilerContext compilerContext) {
        if (callInfo.getArguments().length > 0) {
            throw new PluginException(this, "Call plugin should have no arguments");
        }
        return new DefaultPluginInvoke(){

            @Override
            public void beforeChildren(PushStream stream) {
                String templateVar = compilerContext.generateVariable("templateVar");
                String argsVar = compilerContext.generateVariable("templateOptions");
                MapLiteral args = new MapLiteral(expression.getOptions());
                stream.emit(new VariableBinding.Start(templateVar, expression.getRoot()));
                stream.emit(new VariableBinding.Start(argsVar, args));
                stream.emit(new Procedure.Call(templateVar, argsVar));
                stream.emit(VariableBinding.END);
                stream.emit(VariableBinding.END);
                Patterns.beginStreamIgnore(stream);
            }

            @Override
            public void afterChildren(PushStream stream) {
                Patterns.endStreamIgnore(stream);
            }
        };
    }
}

