/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.impl.compiler.common.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Conditional;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.OutText;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.OutVariable;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.VariableBinding;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.PushStream;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.plugin.MarkupContext;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginComponent;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

@Component
@Service
@Properties(value={@Property(name="service.description", value={"Sightly Resource Block Plugin"}), @Property(name="org.apache.sling.scripting.sightly.impl.plugin.name", value={"element"}), @Property(name="org.apache.sling.scripting.sightly.impl.plugin.priority", intValue={100})})
public class ElementPlugin
extends PluginComponent {
    @Override
    public PluginInvoke invoke(final Expression expression, PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){
            private final ExpressionNode node;
            private String tagVar;
            {
                this.node = compilerContext.adjustToContext(expression, MarkupContext.ELEMENT_NAME, ExpressionContext.ELEMENT).getRoot();
                this.tagVar = compilerContext.generateVariable("tagVar");
            }

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                stream.emit(new VariableBinding.Start(this.tagVar, this.node));
            }

            @Override
            public void beforeTagOpen(PushStream stream) {
                stream.emit(new Conditional.Start(this.tagVar, true));
                stream.emit(new OutText("<"));
                stream.emit(new OutVariable(this.tagVar));
                stream.emit(Conditional.END);
                stream.emit(new Conditional.Start(this.tagVar, false));
            }

            @Override
            public void beforeAttributes(PushStream stream) {
                stream.emit(Conditional.END);
            }

            @Override
            public void beforeTagClose(PushStream stream, boolean isSelfClosing) {
                if (!isSelfClosing) {
                    stream.emit(new Conditional.Start(this.tagVar, true));
                    stream.emit(new OutText("</"));
                    stream.emit(new OutVariable(this.tagVar));
                    stream.emit(new OutText(">"));
                    stream.emit(Conditional.END);
                }
                stream.emit(new Conditional.Start(this.tagVar, false));
            }

            @Override
            public void afterTagClose(PushStream stream, boolean isSelfClosing) {
                stream.emit(Conditional.END);
            }

            @Override
            public void afterElement(PushStream stream) {
                stream.emit(VariableBinding.END);
            }
        };
    }
}

