/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.impl.compiler.common.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Patterns;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Procedure;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.PushStream;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginComponent;
import org.apache.sling.scripting.sightly.impl.plugin.PluginException;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

@Component
@Service
@Properties(value={@Property(name="service.description", value={"Sightly Template Block Plugin"}), @Property(name="org.apache.sling.scripting.sightly.impl.plugin.name", value={"template"}), @Property(name="org.apache.sling.scripting.sightly.impl.plugin.priority", intValue={-2147483648})})
public class TemplatePlugin
extends PluginComponent {
    @Override
    public PluginInvoke invoke(final Expression expressionNode, final PluginCallInfo callInfo, CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){

            @Override
            public void beforeTagOpen(PushStream stream) {
                Patterns.beginStreamIgnore(stream);
            }

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                String name = this.decodeName();
                Set<String> parameters = this.extractParameters();
                stream.emit(new Procedure.Start(name, parameters));
            }

            @Override
            public void afterElement(PushStream stream) {
                stream.emit(Procedure.END);
            }

            @Override
            public void afterTagOpen(PushStream stream) {
                Patterns.endStreamIgnore(stream);
            }

            @Override
            public void beforeTagClose(PushStream stream, boolean isSelfClosing) {
                Patterns.beginStreamIgnore(stream);
            }

            @Override
            public void afterTagClose(PushStream stream, boolean isSelfClosing) {
                Patterns.endStreamIgnore(stream);
            }

            private Set<String> extractParameters() {
                Map<String, ExpressionNode> options = expressionNode.getOptions();
                return options.keySet();
            }

            private String decodeName() {
                String[] arguments = callInfo.getArguments();
                if (arguments.length == 0) {
                    throw new PluginException(TemplatePlugin.this, "template name was not provided");
                }
                return arguments[0];
            }
        };
    }
}

