/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.serviceusermapping.impl;

import java.util.ArrayList;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.serviceusermapping.impl.Mapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, name="org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended", label="Apache Sling Service User Mapper Service Amendment", description="An amendment mapping for the user mapping service.", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={MappingConfigAmendment.class})
@Property(name="service.ranking", intValue={0}, propertyPrivate=false, label="Ranking", description="Amendments are processed in order of their ranking, an amendment with a higher ranking has precedence over a mapping with a lower ranking.")
public class MappingConfigAmendment
implements Comparable<MappingConfigAmendment> {
    @Property(label="Service Mappings", description="Provides mappings from service name to user names. Each entry is of the form 'bundleId [ \":\" subServiceName ] \"=\" userName' where bundleId and subServiceName identify the service and userName defines the name of the user to provide to the service. Invalid entries are logged and ignored.", unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_SERVICE2USER_MAPPING = "user.mapping";
    private static final String[] PROP_SERVICE2USER_MAPPING_DEFAULT = new String[0];
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Mapping[] serviceUserMappings;
    private int serviceRanking;

    @Activate
    @Modified
    void configure(Map<String, Object> config) {
        String[] props = PropertiesUtil.toStringArray((Object)config.get(PROP_SERVICE2USER_MAPPING), (String[])PROP_SERVICE2USER_MAPPING_DEFAULT);
        ArrayList<Mapping> mappings = new ArrayList<Mapping>(props.length);
        for (String prop : props) {
            if (prop == null || prop.trim().length() <= 0) continue;
            try {
                Mapping mapping = new Mapping(prop.trim());
                mappings.add(mapping);
            }
            catch (IllegalArgumentException iae) {
                this.logger.info("configure: Ignoring '{}': {}", (Object)prop, (Object)iae.getMessage());
            }
        }
        this.serviceUserMappings = mappings.toArray(new Mapping[mappings.size()]);
        this.serviceRanking = PropertiesUtil.toInteger((Object)config.get("service.ranking"), (int)0);
    }

    public Mapping[] getServiceUserMappings() {
        return this.serviceUserMappings;
    }

    @Override
    public int compareTo(MappingConfigAmendment o) {
        if (this.serviceRanking > o.serviceRanking) {
            return -1;
        }
        if (this.serviceRanking < o.serviceRanking) {
            return 1;
        }
        return this.hashCode() < o.hashCode() ? -1 : 1;
    }
}

