/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.serviceusermapping.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.apache.sling.serviceusermapping.ServiceUserValidator;
import org.apache.sling.serviceusermapping.impl.Mapping;
import org.apache.sling.serviceusermapping.impl.MappingConfigAmendment;
import org.apache.sling.serviceusermapping.impl.ServiceUserMappedImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="Apache Sling Service User Mapper Service", description="Configuration for the service mapping service names to names of users.")
@Service(value={ServiceUserMapper.class})
@References(value={@Reference(name="amendment", referenceInterface=MappingConfigAmendment.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, updated="updateAmendment"), @Reference(name="serviceUserValidator ", referenceInterface=ServiceUserValidator.class, bind="bindServiceUserValidator", unbind="unbindServiceUserValidator", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public class ServiceUserMapperImpl
implements ServiceUserMapper {
    @Property(label="Service Mappings", description="Provides mappings from service name to user names. Each entry is of the form 'bundleId [ \":\" subServiceName ] \"=\" userName' where bundleId and subServiceName identify the service and userName defines the name of the user to provide to the service. Invalid entries are logged and ignored.", unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_SERVICE2USER_MAPPING = "user.mapping";
    private static final String[] PROP_SERVICE2USER_MAPPING_DEFAULT = new String[0];
    private static final String PROP_DEFAULT_USER = "user.default";
    @Property(name="user.default", label="Default User", description="The name of the user to use as the default if no service mappingapplies. If this property is missing or empty no default user is defined.")
    private static final String PROP_DEFAULT_USER_DEFAULT = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Mapping[] globalServiceUserMappings = new Mapping[0];
    private String defaultUser;
    private Map<Long, MappingConfigAmendment> amendments = new HashMap<Long, MappingConfigAmendment>();
    private Mapping[] activeMappings = new Mapping[0];
    private final List<ServiceUserValidator> validators = new CopyOnWriteArrayList<ServiceUserValidator>();
    private SortedMap<Mapping, ServiceRegistration> activeMappingRegistrations = new TreeMap<Mapping, ServiceRegistration>();
    private BundleContext bundleContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    @Modified
    void configure(BundleContext bundleContext, Map<String, Object> config) {
        String[] props = PropertiesUtil.toStringArray((Object)config.get(PROP_SERVICE2USER_MAPPING), (String[])PROP_SERVICE2USER_MAPPING_DEFAULT);
        ArrayList<Mapping> mappings = new ArrayList<Mapping>(props.length);
        for (String prop : props) {
            if (prop == null || prop.trim().length() <= 0) continue;
            try {
                Mapping mapping = new Mapping(prop.trim());
                mappings.add(mapping);
            }
            catch (IllegalArgumentException iae) {
                this.log.error("configure: Ignoring '{}': {}", (Object)prop, (Object)iae.getMessage());
            }
        }
        this.globalServiceUserMappings = mappings.toArray(new Mapping[mappings.size()]);
        this.defaultUser = PropertiesUtil.toString((Object)config.get(PROP_DEFAULT_USER), (String)PROP_DEFAULT_USER_DEFAULT);
        Map<Long, MappingConfigAmendment> map = this.amendments;
        synchronized (map) {
            this.bundleContext = bundleContext;
            this.updateMappings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    void deactivate() {
        Map<Long, MappingConfigAmendment> map = this.amendments;
        synchronized (map) {
            this.updateServiceMappings(new ArrayList<Mapping>());
            this.bundleContext = null;
        }
    }

    protected void bindServiceUserValidator(ServiceUserValidator serviceUserValidator) {
        this.validators.add(serviceUserValidator);
    }

    protected void unbindServiceUserValidator(ServiceUserValidator serviceUserValidator) {
        this.validators.remove(serviceUserValidator);
    }

    @Override
    public String getServiceUserID(Bundle bundle, String subServiceName) {
        String serviceName = ServiceUserMapperImpl.getServiceName(bundle);
        String userId = this.internalGetUserId(serviceName, subServiceName);
        return this.isValidUser(userId, serviceName, subServiceName) ? userId : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindAmendment(MappingConfigAmendment amendment, Map<String, Object> props) {
        Long key = (Long)props.get("service.id");
        Map<Long, MappingConfigAmendment> map = this.amendments;
        synchronized (map) {
            this.amendments.put(key, amendment);
            this.updateMappings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindAmendment(MappingConfigAmendment amendment, Map<String, Object> props) {
        Long key = (Long)props.get("service.id");
        Map<Long, MappingConfigAmendment> map = this.amendments;
        synchronized (map) {
            if (this.amendments.remove(key) != null) {
                this.updateMappings();
            }
        }
    }

    protected void updateAmendment(MappingConfigAmendment amendment, Map<String, Object> props) {
        this.bindAmendment(amendment, props);
    }

    protected void updateMappings() {
        ArrayList<MappingConfigAmendment> sortedMappings = new ArrayList<MappingConfigAmendment>();
        for (MappingConfigAmendment amendment : this.amendments.values()) {
            sortedMappings.add(amendment);
        }
        Collections.sort(sortedMappings);
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        for (Mapping m : this.globalServiceUserMappings) {
            mappings.add(m);
        }
        for (MappingConfigAmendment mca : sortedMappings) {
            for (Mapping m : mca.getServiceUserMappings()) {
                mappings.add(m);
            }
        }
        this.activeMappings = mappings.toArray(new Mapping[mappings.size()]);
        this.updateServiceMappings(mappings);
    }

    void updateServiceMappings(List<Mapping> newMappings) {
        if (this.bundleContext == null) {
            return;
        }
        TreeSet<Mapping> orderedActiveMappings = new TreeSet<Mapping>(newMappings);
        Iterator<Map.Entry<Mapping, ServiceRegistration>> it = this.activeMappingRegistrations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Mapping, ServiceRegistration> registrationEntry = it.next();
            if (orderedActiveMappings.contains(registrationEntry.getKey())) continue;
            registrationEntry.getValue().unregister();
            it.remove();
        }
        for (Mapping mapping : orderedActiveMappings) {
            if (this.activeMappingRegistrations.containsKey(mapping)) continue;
            Hashtable<String, String> properties = new Hashtable<String, String>();
            if (mapping.getSubServiceName() != null) {
                ((Dictionary)properties).put("subServiceName", mapping.getSubServiceName());
            }
            ((Dictionary)properties).put(Mapping.SERVICENAME, mapping.getServiceName());
            ServiceRegistration registration = this.bundleContext.registerService(ServiceUserMappedImpl.SERVICEUSERMAPPED, (Object)new ServiceUserMappedImpl(), properties);
            this.activeMappingRegistrations.put(mapping, registration);
        }
    }

    private String internalGetUserId(String serviceName, String subServiceName) {
        String userId;
        for (Mapping mapping : this.activeMappings) {
            userId = mapping.map(serviceName, subServiceName);
            if (userId == null) continue;
            return userId;
        }
        for (Mapping mapping : this.activeMappings) {
            userId = mapping.map(serviceName, null);
            if (userId == null) continue;
            return userId;
        }
        return this.defaultUser;
    }

    private boolean isValidUser(String userId, String serviceName, String subServiceName) {
        if (userId == null) {
            return false;
        }
        if (!this.validators.isEmpty()) {
            for (ServiceUserValidator validator : this.validators) {
                if (!validator.isValid(userId, serviceName, subServiceName)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static String getServiceName(Bundle bundle) {
        return bundle.getSymbolicName();
    }
}

