/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers;

import aQute.bnd.annotation.ConsumerType;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.commons.collections.IteratorUtils;
import org.apache.sling.servlethelpers.MockServletContext;

@ConsumerType
public class MockHttpSession
implements HttpSession {
    private final ServletContext servletContext;
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();
    private final String sessionID = UUID.randomUUID().toString();
    private final long creationTime = System.currentTimeMillis();
    private boolean invalidated = false;
    private boolean isNew = true;
    private int maxActiveInterval = 1800;

    public MockHttpSession() {
        this.servletContext = this.newMockServletContext();
    }

    protected MockServletContext newMockServletContext() {
        return new MockServletContext();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Object getAttribute(String name) {
        this.checkInvalidatedState();
        return this.attributeMap.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.checkInvalidatedState();
        return IteratorUtils.asEnumeration(this.attributeMap.keySet().iterator());
    }

    public String getId() {
        return this.sessionID;
    }

    public long getCreationTime() {
        this.checkInvalidatedState();
        return this.creationTime;
    }

    public Object getValue(String name) {
        this.checkInvalidatedState();
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        this.checkInvalidatedState();
        return this.attributeMap.keySet().toArray(new String[this.attributeMap.keySet().size()]);
    }

    public void putValue(String name, Object value) {
        this.checkInvalidatedState();
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.checkInvalidatedState();
        this.attributeMap.remove(name);
    }

    public void removeValue(String name) {
        this.checkInvalidatedState();
        this.attributeMap.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.checkInvalidatedState();
        this.attributeMap.put(name, value);
    }

    public void invalidate() {
        this.checkInvalidatedState();
        this.invalidated = true;
    }

    private void checkInvalidatedState() {
        if (this.invalidated) {
            throw new IllegalStateException("Session is already invalidated.");
        }
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public boolean isNew() {
        this.checkInvalidatedState();
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public long getLastAccessedTime() {
        this.checkInvalidatedState();
        return this.creationTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxActiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxActiveInterval = interval;
    }

    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException();
    }
}

