/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.sling.api.request.RequestParameter;

class MockRequestParameter
implements RequestParameter {
    private String name;
    private String encoding = "UTF-8";
    private String value;
    private byte[] content;

    public MockRequestParameter(String name, String value) {
        this.name = name;
        this.value = value;
        this.content = null;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] get() {
        if (this.content == null) {
            try {
                this.content = this.getString().getBytes(this.getEncoding());
            }
            catch (Exception e) {
                this.content = this.getString().getBytes();
            }
        }
        return this.content;
    }

    public String getContentType() {
        return null;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.get());
    }

    public String getFileName() {
        return null;
    }

    public long getSize() {
        return this.get().length;
    }

    public String getString() {
        return this.value;
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.get(), encoding);
    }

    public boolean isFormField() {
        return true;
    }

    public String toString() {
        return this.getString();
    }
}

