/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.api.wrappers.SlingRequestPaths;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostOperation;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSlingPostOperation
implements SlingPostOperation {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(SlingHttpServletRequest request, HtmlResponse response, SlingPostProcessor[] processors) {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        VersioningConfiguration versionableConfiguration = this.getVersioningConfiguration(request);
        try {
            String path = this.getItemPath(request);
            path = this.removeAndValidateWorkspace(path, session);
            response.setPath(path);
            response.setLocation(this.externalizePath(request, path));
            path = ResourceUtil.getParent((String)path);
            if (path != null) {
                response.setParentLocation(this.externalizePath(request, path));
            }
            ArrayList<Modification> changes = new ArrayList<Modification>();
            this.doRun(request, response, changes);
            for (int i = 0; i < processors.length; ++i) {
                processors[i].process(request, changes);
            }
            LinkedHashSet<String> nodesToCheckin = new LinkedHashSet<String>();
            for (Modification change : changes) {
                switch (change.getType()) {
                    case MODIFY: {
                        response.onModified(change.getSource());
                        break;
                    }
                    case DELETE: {
                        response.onDeleted(change.getSource());
                        break;
                    }
                    case MOVE: {
                        response.onMoved(change.getSource(), change.getDestination());
                        break;
                    }
                    case COPY: {
                        response.onCopied(change.getSource(), change.getDestination());
                        break;
                    }
                    case CREATE: {
                        response.onCreated(change.getSource());
                        if (!versionableConfiguration.isCheckinOnNewVersionableNode()) break;
                        nodesToCheckin.add(change.getSource());
                        break;
                    }
                    case ORDER: {
                        response.onChange("ordered", new String[]{change.getSource(), change.getDestination()});
                        break;
                    }
                    case CHECKOUT: {
                        response.onChange("checkout", new String[]{change.getSource()});
                        nodesToCheckin.add(change.getSource());
                        break;
                    }
                    case CHECKIN: {
                        response.onChange("checkin", new String[]{change.getSource()});
                        nodesToCheckin.remove(change.getSource());
                    }
                }
            }
            if (session.hasPendingChanges()) {
                session.save();
            }
            if (!this.isSkipCheckin(request)) {
                for (String checkinPath : nodesToCheckin) {
                    if (!this.checkin(session, checkinPath)) continue;
                    response.onChange("checkin", new String[]{checkinPath});
                }
            }
        }
        catch (AccessDeniedException e) {
            this.log.error("Access Denied {} ", (Object)e.getMessage());
            this.log.debug("Access Denied Cause ", (Throwable)e);
            response.setError((Throwable)e);
        }
        catch (Exception e) {
            this.log.error("Exception during response processing.", (Throwable)e);
            response.setError((Throwable)e);
        }
        finally {
            try {
                if (session.hasPendingChanges()) {
                    session.refresh(false);
                }
            }
            catch (RepositoryException e) {
                this.log.warn("RepositoryException in finally block: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected VersioningConfiguration getVersioningConfiguration(SlingHttpServletRequest request) {
        VersioningConfiguration versionableConfiguration = (VersioningConfiguration)request.getAttribute(VersioningConfiguration.class.getName());
        return versionableConfiguration != null ? versionableConfiguration : new VersioningConfiguration();
    }

    protected boolean isSkipCheckin(SlingHttpServletRequest request) {
        return !this.getVersioningConfiguration(request).isAutoCheckin();
    }

    protected String removeAndValidateWorkspace(String path, Session session) throws RepositoryException {
        int wsSepPos = path.indexOf(":/");
        if (wsSepPos != -1) {
            String workspaceName = path.substring(0, wsSepPos);
            if (!workspaceName.equals(session.getWorkspace().getName())) {
                throw new RepositoryException("Incorrect workspace. Expecting " + workspaceName + ". Received " + session.getWorkspace().getName());
            }
            return path.substring(wsSepPos + 1);
        }
        return path;
    }

    protected String getItemPath(SlingHttpServletRequest request) {
        return request.getResource().getPath();
    }

    protected abstract void doRun(SlingHttpServletRequest var1, HtmlResponse var2, List<Modification> var3) throws RepositoryException;

    protected Iterator<Resource> getApplyToResources(SlingHttpServletRequest request) {
        String[] applyTo = request.getParameterValues(":applyTo");
        if (applyTo == null) {
            return null;
        }
        return new ApplyToIterator(request, applyTo);
    }

    protected final String externalizePath(SlingHttpServletRequest request, String path) {
        StringBuffer ret = new StringBuffer();
        ret.append(SlingRequestPaths.getContextPath((HttpServletRequest)request));
        ret.append(request.getResourceResolver().map(path));
        String ext = request.getParameter(":displayExtension");
        if (ext != null && ext.length() > 0) {
            if (ext.charAt(0) != '.') {
                ret.append('.');
            }
            ret.append(ext);
        }
        return ret.toString();
    }

    protected final String resolvePath(String absPath, String relPath) {
        if (relPath.startsWith("/")) {
            return relPath;
        }
        return absPath + "/" + relPath;
    }

    protected final boolean requireItemPathPrefix(SlingHttpServletRequest request) {
        boolean requirePrefix = false;
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements() && !requirePrefix) {
            String name = (String)names.nextElement();
            requirePrefix = name.startsWith("./");
        }
        return requirePrefix;
    }

    protected boolean hasItemPathPrefix(String name) {
        return name.startsWith("/") || name.startsWith("./") || name.startsWith("../");
    }

    protected void orderNode(SlingHttpServletRequest request, Item item, List<Modification> changes) throws RepositoryException {
        String command = request.getParameter(":order");
        if (command == null || command.length() == 0) {
            return;
        }
        if (!item.isNode()) {
            return;
        }
        Node parent = item.getParent();
        String next = null;
        if (command.equals("first")) {
            next = parent.getNodes().nextNode().getName();
        } else if (command.equals("last")) {
            next = "";
        } else if (command.startsWith("before ")) {
            next = command.substring("before ".length());
        } else if (command.startsWith("after ")) {
            String name = command.substring("after ".length());
            NodeIterator iter = parent.getNodes();
            while (iter.hasNext()) {
                Node n = iter.nextNode();
                if (!n.getName().equals(name)) continue;
                if (iter.hasNext()) {
                    next = iter.nextNode().getName();
                    continue;
                }
                next = "";
            }
        } else {
            try {
                next = "";
                NodeIterator iter = parent.getNodes();
                for (int newPos = Integer.parseInt(command); iter.hasNext() && newPos >= 0; --newPos) {
                    Node n = iter.nextNode();
                    if (n.getName().equals(item.getName())) {
                        ++newPos;
                    }
                    if (newPos != 0) continue;
                    next = n.getName();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("provided node ordering command is invalid: " + command);
            }
        }
        if (next != null) {
            if (next.equals("")) {
                next = null;
            }
            parent.orderBefore(item.getName(), next);
            changes.add(Modification.onOrder(item.getPath(), next));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Node {} moved '{}'", (Object)item.getPath(), (Object)command);
            }
        } else {
            throw new IllegalArgumentException("provided node ordering command is invalid: " + command);
        }
    }

    protected Node findVersionableAncestor(Node node) throws RepositoryException {
        try {
            while (!this.isVersionable(node)) {
                node = node.getParent();
            }
            return node;
        }
        catch (AccessDeniedException ade) {
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return null;
    }

    protected boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    protected void checkoutIfNecessary(Node node, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException {
        Node versionableNode;
        if (versioningConfiguration.isAutoCheckout() && (versionableNode = this.findVersionableAncestor(node)) != null && !versionableNode.isCheckedOut()) {
            versionableNode.checkout();
            changes.add(Modification.onCheckout(versionableNode.getPath()));
        }
    }

    private boolean checkin(Session session, String path) throws RepositoryException {
        Node node;
        Item item = session.getItem(path);
        if (item instanceof Node && (node = (Node)item).isCheckedOut() && this.isVersionable(node)) {
            node.checkin();
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ApplyToIterator
    implements Iterator<Resource> {
        private final ResourceResolver resolver;
        private final Resource baseResource;
        private final String[] paths;
        private int pathIndex;
        private Resource nextResource;

        ApplyToIterator(SlingHttpServletRequest request, String[] paths) {
            this.resolver = request.getResourceResolver();
            this.baseResource = request.getResource();
            this.paths = paths;
            this.pathIndex = 0;
            this.nextResource = this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.nextResource != null;
        }

        @Override
        public Resource next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Resource result = this.nextResource;
            this.nextResource = this.seek();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Resource seek() {
            while (this.pathIndex < this.paths.length) {
                String path = this.paths[this.pathIndex];
                ++this.pathIndex;
                Resource res = this.resolver.getResource(this.baseResource, path);
                if (res == null) continue;
                return res;
            }
            return null;
        }
    }
}

