/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.contentloader.ContentImporter;
import org.apache.sling.servlets.post.NodeNameGenerator;
import org.apache.sling.servlets.post.SlingPostOperation;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.DateParser;
import org.apache.sling.servlets.post.impl.helper.DefaultNodeNameGenerator;
import org.apache.sling.servlets.post.impl.helper.JSONResponse;
import org.apache.sling.servlets.post.impl.helper.MediaRangeList;
import org.apache.sling.servlets.post.impl.operations.CheckinOperation;
import org.apache.sling.servlets.post.impl.operations.CheckoutOperation;
import org.apache.sling.servlets.post.impl.operations.CopyOperation;
import org.apache.sling.servlets.post.impl.operations.DeleteOperation;
import org.apache.sling.servlets.post.impl.operations.ImportOperation;
import org.apache.sling.servlets.post.impl.operations.ModifyOperation;
import org.apache.sling.servlets.post.impl.operations.MoveOperation;
import org.apache.sling.servlets.post.impl.operations.NopOperation;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingPostServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1837674988291697074L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PROP_DATE_FORMAT = "servlet.post.dateFormats";
    private static final String PROP_NODE_NAME_HINT_PROPERTIES = "servlet.post.nodeNameHints";
    private static final String PROP_NODE_NAME_MAX_LENGTH = "servlet.post.nodeNameMaxLength";
    private static final String PROP_CHECKIN_ON_CREATE = "servlet.post.checkinNewVersionableNodes";
    private static final String PROP_AUTO_CHECKOUT = "servlet.post.autoCheckout";
    private static final String PROP_AUTO_CHECKIN = "servlet.post.autoCheckin";
    private static final boolean DEFAULT_CHECKIN_ON_CREATE = false;
    private static final boolean DEFAULT_AUTO_CHECKOUT = false;
    private static final boolean DEFAULT_AUTO_CHECKIN = true;
    private static final String PARAM_CHECKIN_ON_CREATE = ":checkinNewVersionableNodes";
    private static final String PARAM_AUTO_CHECKOUT = ":autoCheckout";
    private static final String PARAM_AUTO_CHECKIN = ":autoCheckin";
    private DateParser dateParser;
    private ModifyOperation modifyOperation;
    private final List<ServiceReference> delayedPostOperations = new ArrayList<ServiceReference>();
    private final Map<String, SlingPostOperation> postOperations = new HashMap<String, SlingPostOperation>();
    private final List<ServiceReference> delayedPostProcessors = new ArrayList<ServiceReference>();
    private final List<ServiceReference> postProcessors = new ArrayList<ServiceReference>();
    private SlingPostProcessor[] cachedPostProcessors = new SlingPostProcessor[0];
    private final List<ServiceReference> delayedNodeNameGenerators = new ArrayList<ServiceReference>();
    private final List<ServiceReference> nodeNameGenerators = new ArrayList<ServiceReference>();
    private NodeNameGenerator[] cachedNodeNameGenerators = new NodeNameGenerator[0];
    private ComponentContext componentContext;
    private NodeNameGenerator defaultNodeNameGenerator;
    private ImportOperation importOperation;
    private ContentImporter contentImporter;
    private VersioningConfiguration baseVersioningConfiguration;

    public void init() {
        this.modifyOperation = new ModifyOperation(this.defaultNodeNameGenerator, this.dateParser, this.getServletContext());
        this.modifyOperation.setExtraNodeNameGenerators(this.cachedNodeNameGenerators);
        this.postOperations.put("copy", new CopyOperation());
        this.postOperations.put("move", new MoveOperation());
        this.postOperations.put("delete", new DeleteOperation());
        this.postOperations.put("nop", new NopOperation());
        this.postOperations.put("checkin", new CheckinOperation());
        this.postOperations.put("checkout", new CheckoutOperation());
        this.importOperation = new ImportOperation(this.defaultNodeNameGenerator, this.contentImporter);
        this.importOperation.setExtraNodeNameGenerators(this.cachedNodeNameGenerators);
        this.postOperations.put("import", this.importOperation);
    }

    public void destroy() {
        this.modifyOperation = null;
        this.postOperations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String redirect;
        VersioningConfiguration localVersioningConfig = this.createRequestVersioningConfiguration(request);
        request.setAttribute(VersioningConfiguration.class.getName(), (Object)localVersioningConfig);
        HtmlResponse htmlResponse = this.createHtmlResponse(request);
        htmlResponse.setReferer(request.getHeader("referer"));
        SlingPostOperation operation = this.getSlingPostOperation(request);
        if (operation == null) {
            htmlResponse.setStatus(500, "Invalid operation specified for POST request");
        } else {
            SlingPostProcessor[] processors;
            List<ServiceReference> list = this.delayedPostProcessors;
            synchronized (list) {
                processors = this.cachedPostProcessors;
            }
            try {
                operation.run(request, htmlResponse, processors);
            }
            catch (ResourceNotFoundException rnfe) {
                htmlResponse.setStatus(404, rnfe.getMessage());
            }
            catch (Throwable throwable) {
                this.log.debug("Exception while handling POST " + request.getResource().getPath() + " with " + operation.getClass().getName(), throwable);
                htmlResponse.setError(throwable);
            }
        }
        if (htmlResponse.isSuccessful() && (redirect = this.getRedirectUrl((HttpServletRequest)request, htmlResponse)) != null) {
            response.sendRedirect(redirect);
            return;
        }
        htmlResponse.send((HttpServletResponse)response, this.isSetStatus(request));
    }

    HtmlResponse createHtmlResponse(SlingHttpServletRequest req) {
        MediaRangeList mediaRangeList = new MediaRangeList((HttpServletRequest)req);
        if ("application/json".equals(mediaRangeList.prefer("text/html", "application/json"))) {
            return new JSONResponse();
        }
        return new HtmlResponse();
    }

    private SlingPostOperation getSlingPostOperation(SlingHttpServletRequest request) {
        String operation = request.getParameter(":operation");
        if (operation == null || operation.length() == 0) {
            return this.modifyOperation;
        }
        return this.postOperations.get(operation);
    }

    protected String getRedirectUrl(HttpServletRequest request, HtmlResponse ctx) {
        String result = request.getParameter(":redirect");
        if (result != null && ctx.getPath() != null) {
            int star = result.indexOf(42);
            if (star >= 0) {
                StringBuffer buf = new StringBuffer();
                if (star > 0) {
                    buf.append(result.substring(0, star));
                }
                buf.append(ResourceUtil.getName((String)ctx.getPath()));
                if (star < result.length() - 1) {
                    buf.append(result.substring(star + 1));
                }
                result = buf.toString();
            } else if (result.endsWith("/")) {
                result = result.concat(ResourceUtil.getName((String)ctx.getPath()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Will redirect to " + result);
            }
        }
        return result;
    }

    protected boolean isSetStatus(SlingHttpServletRequest request) {
        String statusParam = request.getParameter(":status");
        if (statusParam == null) {
            this.log.debug("getStatusMode: Parameter {} not set, assuming standard status code", (Object)":status");
            return true;
        }
        if ("browser".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for user-friendly status code", (Object)":status");
            return false;
        }
        if ("standard".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for standard status code", (Object)":status");
            return true;
        }
        this.log.debug("getStatusMode: Parameter {} set to unknown value {}, assuming standard status code", (Object)":status");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) {
        String[] dateFormats;
        List<ServiceReference> list = this.delayedPostProcessors;
        synchronized (list) {
            this.componentContext = context;
            for (ServiceReference ref : this.delayedPostProcessors) {
                this.registerPostProcessor(ref);
            }
            this.delayedPostProcessors.clear();
        }
        list = this.delayedPostOperations;
        synchronized (list) {
            for (ServiceReference ref : this.delayedPostOperations) {
                this.registerPostOperation(ref);
            }
            this.delayedPostOperations.clear();
        }
        Dictionary props = context.getProperties();
        String[] nameHints = OsgiUtil.toStringArray(props.get(PROP_NODE_NAME_HINT_PROPERTIES));
        int nameMax = (int)OsgiUtil.toLong(props.get(PROP_NODE_NAME_MAX_LENGTH), (long)-1L);
        this.defaultNodeNameGenerator = new DefaultNodeNameGenerator(nameHints, nameMax);
        this.dateParser = new DateParser();
        for (String dateFormat : dateFormats = OsgiUtil.toStringArray(props.get(PROP_DATE_FORMAT))) {
            try {
                this.dateParser.register(dateFormat);
            }
            catch (Throwable t) {
                this.log.warn("activate: Ignoring format {} because it is invalid: {}", (Object)dateFormat, (Object)t);
            }
        }
        List<ServiceReference> list2 = this.delayedNodeNameGenerators;
        synchronized (list2) {
            for (ServiceReference ref : this.delayedNodeNameGenerators) {
                this.registerNodeNameGenerator(ref);
            }
            this.delayedNodeNameGenerators.clear();
        }
        this.baseVersioningConfiguration = this.createBaseVersioningConfiguration(props);
    }

    protected void deactivate(ComponentContext context) {
        this.dateParser = null;
        this.componentContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPostOperation(ServiceReference ref) {
        List<ServiceReference> list = this.delayedPostOperations;
        synchronized (list) {
            if (this.componentContext == null) {
                this.delayedPostOperations.add(ref);
            } else {
                this.registerPostOperation(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerPostOperation(ServiceReference ref) {
        String operationName = (String)ref.getProperty("sling.post.operation");
        SlingPostOperation operation = (SlingPostOperation)this.componentContext.locateService("postOperation", ref);
        if (operation != null) {
            Map<String, SlingPostOperation> map = this.postOperations;
            synchronized (map) {
                this.postOperations.put(operationName, operation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPostOperation(ServiceReference ref) {
        List<ServiceReference> list = this.delayedPostOperations;
        synchronized (list) {
            String operationName = (String)ref.getProperty("sling.post.operation");
            Map<String, SlingPostOperation> map = this.postOperations;
            synchronized (map) {
                this.postOperations.remove(operationName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPostProcessor(ServiceReference ref) {
        List<ServiceReference> list = this.delayedPostProcessors;
        synchronized (list) {
            if (this.componentContext == null) {
                this.delayedPostProcessors.add(ref);
            } else {
                this.registerPostProcessor(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPostProcessor(ServiceReference ref) {
        List<ServiceReference> list = this.delayedPostProcessors;
        synchronized (list) {
            this.delayedPostProcessors.remove(ref);
            this.postProcessors.remove(ref);
        }
    }

    protected void registerPostProcessor(ServiceReference ref) {
        int index;
        int ranking = OsgiUtil.toInteger((Object)ref.getProperty("service.ranking"), (int)0);
        for (index = 0; index < this.postProcessors.size() && ranking < OsgiUtil.toInteger((Object)this.postProcessors.get(index).getProperty("service.ranking"), (int)0); ++index) {
        }
        if (index == this.postProcessors.size()) {
            this.postProcessors.add(ref);
        } else {
            this.postProcessors.add(index, ref);
        }
        this.cachedPostProcessors = new SlingPostProcessor[this.postProcessors.size()];
        index = 0;
        for (ServiceReference current : this.postProcessors) {
            SlingPostProcessor processor = (SlingPostProcessor)this.componentContext.locateService("postProcessor", current);
            if (processor == null) continue;
            this.cachedPostProcessors[index] = processor;
            ++index;
        }
        if (index < this.cachedPostProcessors.length) {
            SlingPostProcessor[] oldArray = this.cachedPostProcessors;
            this.cachedPostProcessors = new SlingPostProcessor[index];
            for (int i = 0; i < index; ++i) {
                this.cachedPostProcessors[i] = oldArray[i];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindNodeNameGenerator(ServiceReference ref) {
        List<ServiceReference> list = this.delayedNodeNameGenerators;
        synchronized (list) {
            if (this.componentContext == null) {
                this.delayedNodeNameGenerators.add(ref);
            } else {
                this.registerNodeNameGenerator(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindNodeNameGenerator(ServiceReference ref) {
        List<ServiceReference> list = this.delayedNodeNameGenerators;
        synchronized (list) {
            this.delayedNodeNameGenerators.remove(ref);
            this.nodeNameGenerators.remove(ref);
        }
    }

    protected void registerNodeNameGenerator(ServiceReference ref) {
        int index;
        int ranking = OsgiUtil.toInteger((Object)ref.getProperty("service.ranking"), (int)0);
        for (index = 0; index < this.nodeNameGenerators.size() && ranking < OsgiUtil.toInteger((Object)this.nodeNameGenerators.get(index).getProperty("service.ranking"), (int)0); ++index) {
        }
        if (index == this.nodeNameGenerators.size()) {
            this.nodeNameGenerators.add(ref);
        } else {
            this.nodeNameGenerators.add(index, ref);
        }
        this.cachedNodeNameGenerators = new NodeNameGenerator[this.nodeNameGenerators.size()];
        index = 0;
        for (ServiceReference current : this.nodeNameGenerators) {
            NodeNameGenerator generator = (NodeNameGenerator)this.componentContext.locateService("nodeNameGenerator", current);
            if (generator == null) continue;
            this.cachedNodeNameGenerators[index] = generator;
            ++index;
        }
        if (index < this.cachedNodeNameGenerators.length) {
            NodeNameGenerator[] oldArray = this.cachedNodeNameGenerators;
            this.cachedNodeNameGenerators = new NodeNameGenerator[index];
            for (int i = 0; i < index; ++i) {
                this.cachedNodeNameGenerators[i] = oldArray[i];
            }
        }
        if (this.modifyOperation != null) {
            this.modifyOperation.setExtraNodeNameGenerators(this.cachedNodeNameGenerators);
        }
        if (this.importOperation != null) {
            this.importOperation.setExtraNodeNameGenerators(this.cachedNodeNameGenerators);
        }
    }

    protected void bindContentImporter(ContentImporter importer) {
        this.contentImporter = importer;
        if (this.importOperation != null) {
            this.importOperation.setContentImporter(importer);
        }
    }

    protected void unbindContentImporter(ContentImporter importer) {
        this.contentImporter = null;
        if (this.importOperation != null) {
            this.importOperation.setContentImporter(null);
        }
    }

    private VersioningConfiguration createBaseVersioningConfiguration(Dictionary<?, ?> props) {
        VersioningConfiguration cfg = new VersioningConfiguration();
        cfg.setCheckinOnNewVersionableNode(OsgiUtil.toBoolean(props.get(PROP_CHECKIN_ON_CREATE), (boolean)false));
        cfg.setAutoCheckout(OsgiUtil.toBoolean(props.get(PROP_AUTO_CHECKOUT), (boolean)false));
        cfg.setAutoCheckin(OsgiUtil.toBoolean(props.get(PROP_AUTO_CHECKIN), (boolean)true));
        return cfg;
    }

    private VersioningConfiguration createRequestVersioningConfiguration(SlingHttpServletRequest request) {
        VersioningConfiguration cfg = this.baseVersioningConfiguration.clone();
        String paramValue = request.getParameter(PARAM_CHECKIN_ON_CREATE);
        if (paramValue != null) {
            cfg.setCheckinOnNewVersionableNode(Boolean.parseBoolean(paramValue));
        }
        if ((paramValue = request.getParameter(PARAM_AUTO_CHECKOUT)) != null) {
            cfg.setAutoCheckout(Boolean.parseBoolean(paramValue));
        }
        if ((paramValue = request.getParameter(PARAM_AUTO_CHECKIN)) != null) {
            cfg.setAutoCheckin(Boolean.parseBoolean(paramValue));
        }
        return cfg;
    }
}

