/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class JSONResponse
extends HtmlResponse {
    private JSONObject json = new JSONObject();
    private JSONArray changes = new JSONArray();
    private Boolean delayedIsCreateRequest;
    static final String PROP_CHANGES = "changes";
    static final String PROP_TYPE = "type";
    static final String PROP_ARGUMENT = "argument";
    public static final String RESPONSE_CONTENT_TYPE = "application/json";
    static final String RESPONSE_CHARSET = "UTF-8";
    private Throwable error;

    public JSONResponse() throws JSONResponseException {
        try {
            this.json = new JSONObject();
            this.changes = new JSONArray();
            this.json.put(PROP_CHANGES, (Object)this.changes);
            if (this.delayedIsCreateRequest != null) {
                this.setCreateRequest(this.delayedIsCreateRequest);
            }
        }
        catch (Throwable e) {
            throw new JSONResponseException(e);
        }
    }

    public void onChange(String type, String ... arguments) throws JSONResponseException {
        try {
            JSONObject change = new JSONObject();
            change.put(PROP_TYPE, (Object)type);
            for (String argument : arguments) {
                change.accumulate(PROP_ARGUMENT, (Object)argument);
            }
            this.changes.put((Object)change);
        }
        catch (JSONException e) {
            throw new JSONResponseException((Throwable)e);
        }
    }

    public void setError(Throwable error) {
        try {
            this.error = error;
            JSONObject jsonError = new JSONObject();
            jsonError.put("class", (Object)error.getClass().getName());
            jsonError.put("message", (Object)error.getMessage());
            this.json.put("error", (Object)jsonError);
        }
        catch (JSONException e) {
            throw new JSONResponseException((Throwable)e);
        }
    }

    public Throwable getError() {
        return this.error;
    }

    public void setCreateRequest(boolean isCreateRequest) {
        if (this.json != null) {
            super.setCreateRequest(isCreateRequest);
        } else {
            this.delayedIsCreateRequest = isCreateRequest;
        }
    }

    public void setProperty(String name, Object value) {
        try {
            this.json.put(name, value);
        }
        catch (Throwable e) {
            throw new JSONResponseException("Error setting JSON property '" + name + "' to '" + value + "'", e);
        }
    }

    public Object getProperty(String name) throws JSONResponseException {
        try {
            if (this.json.has(name)) {
                return this.json.get(name);
            }
            return null;
        }
        catch (JSONException e) {
            throw new JSONResponseException("Error getting JSON property '" + name + "'", e);
        }
    }

    public void send(HttpServletResponse response, boolean setStatus) throws IOException {
        Object status;
        String referer;
        String path = this.getPath();
        if (this.getProperty("status.code") == null) {
            if (this.getError() != null) {
                this.setStatus(500, this.getError().toString());
                this.setTitle("Error while processing " + path);
            } else if (this.isCreateRequest()) {
                this.setStatus(201, "Created");
                this.setTitle("Content created " + path);
            } else {
                this.setStatus(200, "OK");
                this.setTitle("Content modified " + path);
            }
        }
        if ((referer = this.getReferer()) == null) {
            referer = "";
        }
        this.setReferer(referer);
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setCharacterEncoding(RESPONSE_CHARSET);
        if (setStatus && (status = this.getProperty("status.code")) instanceof Number) {
            int statusCode = ((Number)status).intValue();
            response.setStatus(statusCode);
            if (statusCode == 201) {
                response.setHeader("Location", this.getLocation());
            }
        }
        try {
            this.json.write((Writer)response.getWriter());
        }
        catch (JSONException e) {
            IOException ioe = new IOException("Error creating JSON response");
            ioe.initCause(e);
            throw ioe;
        }
    }

    JSONObject getJson() {
        return this.json;
    }

    public class JSONResponseException
    extends RuntimeException {
        public JSONResponseException(String message, Throwable exception) {
            super(message, exception);
        }

        public JSONResponseException(Throwable e) {
            super("Error building JSON response", e);
        }
    }
}

