/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.servlet.ServletContext;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingFileUploadHandler {
    public static final String NT_FOLDER = "nt:folder";
    public static final String NT_FILE = "nt:file";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_LASTMODIFIED = "jcr:lastModified";
    public static final String JCR_MIMETYPE = "jcr:mimeType";
    public static final String JCR_ENCODING = "jcr:encoding";
    public static final String JCR_DATA = "jcr:data";
    private final ServletContext servletContext;

    public SlingFileUploadHandler(ServletContext servletCtx) {
        this.servletContext = servletCtx;
    }

    public void setFile(Node parent, RequestProperty prop, List<Modification> changes) throws RepositoryException {
        RequestParameter[] values;
        for (RequestParameter requestParameter : values = prop.getValues()) {
            int idx;
            Node resParent;
            RequestParameter value = requestParameter;
            if (value.isFormField() || value.getSize() <= 0L) continue;
            String name = prop.getName();
            if (name.equals("*")) {
                name = value.getFileName();
                name = name.substring(name.lastIndexOf(47) + 1);
                name = name.substring(name.lastIndexOf(92) + 1);
            }
            name = Text.escapeIllegalJcrChars(name);
            boolean createNtFile = parent.isNodeType(NT_FOLDER);
            String typeHint = prop.getTypeHint();
            if (typeHint != null) {
                try {
                    NodeTypeManager ntMgr = parent.getSession().getWorkspace().getNodeTypeManager();
                    NodeType nt = ntMgr.getNodeType(typeHint);
                    createNtFile = nt.isNodeType(NT_FILE);
                }
                catch (RepositoryException e) {
                    typeHint = null;
                }
            }
            if (!createNtFile && name.indexOf(46) > 0) {
                createNtFile = true;
            }
            if (typeHint == null) {
                String string = typeHint = createNtFile ? NT_FILE : NT_RESOURCE;
            }
            if (createNtFile) {
                resParent = this.getOrCreateChildNode(parent, name, typeHint, changes);
                name = JCR_CONTENT;
                typeHint = NT_RESOURCE;
            } else {
                resParent = parent;
            }
            Node res = this.getOrCreateChildNode(resParent, name, typeHint, changes);
            String contentType = value.getContentType();
            if (contentType != null && (idx = contentType.indexOf(59)) > 0) {
                contentType = contentType.substring(0, idx);
            }
            if ((contentType == null || contentType.equals("application/octet-stream")) && ((contentType = this.servletContext.getMimeType(value.getFileName())) == null || contentType.equals("application/octet-stream"))) {
                contentType = "application/octet-stream";
            }
            changes.add(Modification.onModified(res.setProperty(JCR_LASTMODIFIED, Calendar.getInstance()).getPath()));
            changes.add(Modification.onModified(res.setProperty(JCR_MIMETYPE, contentType).getPath()));
            try {
                changes.add(Modification.onModified(res.setProperty(JCR_DATA, value.getInputStream()).getPath()));
            }
            catch (IOException e) {
                throw new RepositoryException("Error while retrieving inputstream from parameter value.", (Throwable)e);
            }
        }
    }

    private Node getOrCreateChildNode(Node parent, String name, String typeHint, List<Modification> changes) throws RepositoryException {
        Node result;
        if (parent.hasNode(name)) {
            Node existing = parent.getNode(name);
            if (!existing.isNodeType(typeHint)) {
                existing.remove();
                result = this.createWithChanges(parent, name, typeHint, changes);
            } else {
                result = existing;
            }
        } else {
            result = this.createWithChanges(parent, name, typeHint, changes);
        }
        return result;
    }

    private Node createWithChanges(Node parent, String name, String typeHint, List<Modification> changes) throws RepositoryException {
        Node result = parent.addNode(name, typeHint);
        changes.add(Modification.onCreated(result.getPath()));
        return result;
    }
}

