/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.helper.DateParser;
import org.apache.sling.servlets.post.impl.helper.ReferenceParser;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingPropertyValueHandler {
    private static final Map<String, AutoType> AUTO_PROPS = new HashMap<String, AutoType>();
    private final List<Modification> changes;
    private final DateParser dateParser;
    private final ReferenceParser referenceParser;
    private final Calendar now = Calendar.getInstance();
    private static final int PROPERTY_TYPE_WEAKREFERENCE = 10;

    public SlingPropertyValueHandler(DateParser dateParser, ReferenceParser referenceParser, List<Modification> changes) {
        this.dateParser = dateParser;
        this.referenceParser = referenceParser;
        this.changes = changes;
    }

    public void setProperty(Node parent, RequestProperty prop) throws RepositoryException {
        String name = prop.getName();
        if (prop.providesValue()) {
            this.setPropertyAsIs(parent, prop);
        } else if (AUTO_PROPS.containsKey(name)) {
            try {
                switch (AUTO_PROPS.get(name)) {
                    case CREATED: {
                        if (!parent.isNew()) break;
                        this.setCurrentDate(parent, name);
                        break;
                    }
                    case CREATED_BY: {
                        if (!parent.isNew()) break;
                        this.setCurrentUser(parent, name);
                        break;
                    }
                    case MODIFIED: {
                        this.setCurrentDate(parent, name);
                        break;
                    }
                    case MODIFIED_BY: {
                        this.setCurrentUser(parent, name);
                    }
                }
            }
            catch (ConstraintViolationException e) {}
        } else {
            this.setPropertyAsIs(parent, prop);
        }
    }

    private void setCurrentDate(Node parent, String name) throws RepositoryException {
        this.removePropertyIfExists(parent, name);
        this.changes.add(Modification.onModified(parent.setProperty(name, this.now).getPath()));
    }

    private void setCurrentUser(Node parent, String name) throws RepositoryException {
        this.removePropertyIfExists(parent, name);
        this.changes.add(Modification.onModified(parent.setProperty(name, parent.getSession().getUserID()).getPath()));
    }

    private String removePropertyIfExists(Node parent, String name) throws RepositoryException {
        Property prop;
        if (parent.hasProperty(name) && !(prop = parent.getProperty(name)).getDefinition().isMandatory()) {
            String path = prop.getPath();
            prop.remove();
            return path;
        }
        return null;
    }

    private void setPropertyAsIs(Node parent, RequestProperty prop) throws RepositoryException {
        ValueFactory valFac = parent.getSession().getValueFactory();
        int type = 0;
        if (prop.getTypeHint() != null) {
            try {
                type = PropertyType.valueFromName((String)prop.getTypeHint());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String[] values = prop.getStringValues();
        if (type == 0 && values != null && values.length > 0 && parent.hasProperty(prop.getName())) {
            type = parent.getProperty(prop.getName()).getType();
        }
        if (values == null) {
            String removePath = this.removePropertyIfExists(parent, prop.getName());
            if (removePath != null) {
                this.changes.add(Modification.onDeleted(removePath));
            }
        } else if (values.length == 0) {
            if (parent.hasProperty(prop.getName())) {
                if (parent.getProperty(prop.getName()).getDefinition().isMultiple()) {
                    String removePath = this.removePropertyIfExists(parent, prop.getName());
                    if (removePath != null) {
                        this.changes.add(Modification.onDeleted(removePath));
                    }
                } else {
                    this.changes.add(Modification.onModified(parent.setProperty(prop.getName(), "").getPath()));
                }
            }
        } else if (values.length == 1) {
            boolean storePropertyAsMultiValued = prop.hasMultiValueTypeHint();
            if (!prop.hasMultiValueTypeHint() && parent.hasProperty(prop.getName())) {
                storePropertyAsMultiValued = parent.getProperty(prop.getName()).getDefinition().isMultiple();
            }
            if (values[0].length() == 0) {
                String removePath = this.removePropertyIfExists(parent, prop.getName());
                if (removePath != null) {
                    this.changes.add(Modification.onDeleted(removePath));
                }
            } else {
                Property p;
                Value v;
                if (type == 5) {
                    Calendar c = this.dateParser.parse(values[0]);
                    if (c != null) {
                        if (storePropertyAsMultiValued) {
                            Value[] array = new Value[]{parent.getSession().getValueFactory().createValue(c)};
                            this.changes.add(Modification.onModified(parent.setProperty(prop.getName(), array).getPath()));
                        } else {
                            this.changes.add(Modification.onModified(parent.setProperty(prop.getName(), c).getPath()));
                        }
                        return;
                    }
                } else if (this.isReferencePropertyType(type) && (v = this.referenceParser.parse(values[0], valFac, this.isWeakReference(type))) != null) {
                    if (storePropertyAsMultiValued) {
                        Value[] array = new Value[]{v};
                        this.changes.add(Modification.onModified(parent.setProperty(prop.getName(), array).getPath()));
                    } else {
                        this.changes.add(Modification.onModified(parent.setProperty(prop.getName(), v).getPath()));
                    }
                    return;
                }
                if (type == 0) {
                    if (storePropertyAsMultiValued) {
                        Value[] array = new Value[]{parent.getSession().getValueFactory().createValue(values[0])};
                        p = parent.setProperty(prop.getName(), array);
                    } else {
                        p = parent.setProperty(prop.getName(), values[0]);
                    }
                } else if (storePropertyAsMultiValued) {
                    Value[] array = new Value[]{parent.getSession().getValueFactory().createValue(values[0], type)};
                    p = parent.setProperty(prop.getName(), array);
                } else {
                    p = parent.setProperty(prop.getName(), values[0], type);
                }
                this.changes.add(Modification.onModified(p.getPath()));
            }
        } else {
            Value[] n;
            String removePath;
            if (parent.hasProperty(prop.getName()) && !parent.getProperty(prop.getName()).getDefinition().isMultiple() && (removePath = this.removePropertyIfExists(parent, prop.getName())) != null) {
                this.changes.add(Modification.onDeleted(removePath));
            }
            if (type == 5) {
                Value[] c = this.dateParser.parse(values, valFac);
                if (c != null) {
                    this.changes.add(Modification.onModified(parent.setProperty(prop.getName(), c).getPath()));
                    return;
                }
            } else if (this.isReferencePropertyType(type) && (n = this.referenceParser.parse(values, valFac, this.isWeakReference(type))) != null) {
                this.changes.add(Modification.onModified(parent.setProperty(prop.getName(), n).getPath()));
                return;
            }
            Property p = type == 0 ? parent.setProperty(prop.getName(), values) : parent.setProperty(prop.getName(), values, type);
            this.changes.add(Modification.onModified(p.getPath()));
        }
    }

    private boolean isReferencePropertyType(int propertyType) {
        return propertyType == 9 || propertyType == 10;
    }

    private boolean isWeakReference(int propertyType) {
        return propertyType == 10;
    }

    static {
        AUTO_PROPS.put("created", AutoType.CREATED);
        AUTO_PROPS.put("createdBy", AutoType.CREATED_BY);
        AUTO_PROPS.put("jcr:created", AutoType.CREATED);
        AUTO_PROPS.put("jcr:createdBy", AutoType.CREATED_BY);
        AUTO_PROPS.put("lastModified", AutoType.MODIFIED);
        AUTO_PROPS.put("lastModifiedBy", AutoType.MODIFIED_BY);
        AUTO_PROPS.put("jcr:lastModified", AutoType.MODIFIED);
        AUTO_PROPS.put("jcr:lastModifiedBy", AutoType.MODIFIED_BY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AutoType {
        CREATED,
        CREATED_BY,
        MODIFIED,
        MODIFIED_BY;

    }
}

