/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.servlets.post.AbstractSlingPostOperation;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.NodeNameGenerator;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCreateOperation
extends AbstractSlingPostOperation {
    private final NodeNameGenerator defaultNodeNameGenerator;
    private NodeNameGenerator[] extraNodeNameGenerators;

    public AbstractCreateOperation(NodeNameGenerator defaultNodeNameGenerator) {
        this.defaultNodeNameGenerator = defaultNodeNameGenerator;
    }

    public void setExtraNodeNameGenerators(NodeNameGenerator[] extraNodeNameGenerators) {
        this.extraNodeNameGenerators = extraNodeNameGenerators;
    }

    protected void processCreate(Session session, Map<String, RequestProperty> reqProperties, HtmlResponse response, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException {
        String path = response.getPath();
        if (!session.itemExists(path)) {
            this.deepGetOrCreateNode(session, path, reqProperties, changes, versioningConfiguration);
            response.setCreateRequest(true);
        } else {
            this.updateMixins(session, path, reqProperties, changes, versioningConfiguration);
        }
    }

    protected void updateMixins(Session session, String path, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PathNotFoundException, RepositoryException, NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException {
        Item item;
        String[] mixins = this.getMixinTypes(reqProperties, path);
        if (mixins != null && (item = session.getItem(path)).isNode()) {
            HashSet<String> newMixins = new HashSet<String>();
            newMixins.addAll(Arrays.asList(mixins));
            Node node = (Node)item;
            this.checkoutIfNecessary(node, changes, versioningConfiguration);
            for (NodeType mixin : node.getMixinNodeTypes()) {
                String mixinName = mixin.getName();
                if (newMixins.remove(mixinName)) continue;
                node.removeMixin(mixinName);
            }
            for (String mixin : newMixins) {
                node.addMixin(mixin);
                if (!mixin.equals("mix:versionable") || !versioningConfiguration.isCheckinOnNewVersionableNode()) continue;
                changes.add(Modification.onCheckout(path));
            }
        }
    }

    protected Map<String, RequestProperty> collectContent(SlingHttpServletRequest request, HtmlResponse response) {
        boolean requireItemPrefix = this.requireItemPathPrefix(request);
        LinkedHashMap<String, RequestProperty> reqProperties = new LinkedHashMap<String, RequestProperty>();
        for (Map.Entry e : request.getRequestParameterMap().entrySet()) {
            String sourcePath;
            RequestProperty prop;
            String paramName = (String)e.getKey();
            if (paramName.startsWith(":") || paramName.equals("_charset_") || requireItemPrefix && !this.hasItemPathPrefix(paramName)) continue;
            String propPath = this.toPropertyPath(paramName, response);
            if (propPath.endsWith("@TypeHint")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@TypeHint");
                RequestParameter[] rp = (RequestParameter[])e.getValue();
                if (rp.length <= 0) continue;
                prop.setTypeHintValue(rp[0].getString());
                continue;
            }
            if (propPath.endsWith("@DefaultValue")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@DefaultValue");
                prop.setDefaultValues((RequestParameter[])e.getValue());
                continue;
            }
            if (propPath.endsWith("@ValueFrom")) {
                String refName;
                RequestParameter[] refValues;
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@ValueFrom");
                if (((RequestParameter[])e.getValue()).length != 1 || (refValues = request.getRequestParameters(refName = ((RequestParameter[])e.getValue())[0].getString())) == null) continue;
                prop.setValues(refValues);
                continue;
            }
            if (propPath.endsWith("@Delete")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@Delete");
                prop.setDelete(true);
                continue;
            }
            if (propPath.endsWith("@MoveFrom")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@MoveFrom");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                sourcePath = ((RequestParameter[])e.getValue())[0].getString();
                prop.setRepositorySource(sourcePath, true);
                continue;
            }
            if (propPath.endsWith("@CopyFrom")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@CopyFrom");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                sourcePath = ((RequestParameter[])e.getValue())[0].getString();
                prop.setRepositorySource(sourcePath, false);
                continue;
            }
            if (propPath.endsWith("@IgnoreBlanks")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@IgnoreBlanks");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                prop.setIgnoreBlanks(true);
                continue;
            }
            if (propPath.endsWith("@UseDefaultWhenMissing")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@UseDefaultWhenMissing");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                prop.setUseDefaultWhenMissing(true);
                continue;
            }
            prop = this.getOrCreateRequestProperty(reqProperties, propPath, null);
            prop.setValues((RequestParameter[])e.getValue());
        }
        return reqProperties;
    }

    private String toPropertyPath(String paramName, HtmlResponse response) {
        if (!paramName.startsWith("/")) {
            paramName = ResourceUtil.normalize((String)(response.getPath() + '/' + paramName));
        }
        return paramName;
    }

    private RequestProperty getOrCreateRequestProperty(Map<String, RequestProperty> props, String paramName, String suffix) {
        RequestProperty prop;
        if (suffix != null && paramName.endsWith(suffix)) {
            paramName = paramName.substring(0, paramName.length() - suffix.length());
        }
        if ((prop = props.get(paramName)) == null) {
            prop = new RequestProperty(paramName);
            props.put(paramName, prop);
        }
        return prop;
    }

    protected Node deepGetOrCreateNode(Session session, String path, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deep-creating Node '{}'", (Object)path);
        }
        if (path == null || !path.startsWith("/")) {
            throw new IllegalArgumentException("path must be an absolute path.");
        }
        String startingNodePath = path;
        Node startingNode = null;
        while (startingNode == null) {
            if (startingNodePath.equals("/")) {
                startingNode = session.getRootNode();
                continue;
            }
            if (session.itemExists(startingNodePath)) {
                startingNode = (Node)session.getItem(startingNodePath);
                this.updateMixins(session, startingNodePath, reqProperties, changes, versioningConfiguration);
                continue;
            }
            int pos = startingNodePath.lastIndexOf(47);
            if (pos > 0) {
                startingNodePath = startingNodePath.substring(0, pos);
                continue;
            }
            startingNodePath = "/";
        }
        if (startingNodePath.length() == path.length()) {
            return startingNode;
        }
        int from = startingNodePath.length() == 1 ? 1 : startingNodePath.length() + 1;
        Node node = startingNode;
        while (from > 0) {
            String name;
            int to = path.indexOf(47, from);
            String string = name = to < 0 ? path.substring(from) : path.substring(from, to);
            if (node.hasNode(name)) {
                node = node.getNode(name);
                this.updateMixins(session, node.getPath(), reqProperties, changes, versioningConfiguration);
            } else {
                String tmpPath = to < 0 ? path : path.substring(0, to);
                String nodeType = this.getPrimaryType(reqProperties, tmpPath);
                this.checkoutIfNecessary(node, changes, versioningConfiguration);
                try {
                    node = nodeType != null ? node.addNode(name, nodeType) : node.addNode(name);
                }
                catch (VersionException e) {
                    this.log.error("Unable to create node named " + name + " in " + node.getPath());
                    throw e;
                }
                String[] mixinTypes = this.getMixinTypes(reqProperties, tmpPath);
                if (mixinTypes != null) {
                    for (String mix : mixinTypes) {
                        node.addMixin(mix);
                    }
                }
                changes.add(Modification.onCreated(node.getPath()));
            }
            from = to + 1;
        }
        return node;
    }

    private String getPrimaryType(Map<String, RequestProperty> reqProperties, String path) {
        RequestProperty prop = reqProperties.get(path + "/jcr:primaryType");
        return prop == null ? null : prop.getStringValues()[0];
    }

    private String[] getMixinTypes(Map<String, RequestProperty> reqProperties, String path) {
        RequestProperty prop = reqProperties.get(path + "/jcr:mixinTypes");
        return prop == null || !prop.hasValues() ? null : prop.getStringValues();
    }

    protected String generateName(SlingHttpServletRequest request, String basePath) throws RepositoryException {
        RequestParameterMap parameters = request.getRequestParameterMap();
        RequestParameter specialParam = parameters.getValue(":name");
        if (specialParam != null && specialParam.getString() != null && specialParam.getString().length() > 0) {
            String jcrPath;
            basePath = basePath + "/" + specialParam.getString();
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            if (session.itemExists(jcrPath = this.removeAndValidateWorkspace(basePath, session))) {
                throw new RepositoryException("Collision in node names for path=" + basePath);
            }
            return basePath;
        }
        boolean requirePrefix = this.requireItemPathPrefix(request);
        String generatedName = null;
        if (this.extraNodeNameGenerators != null) {
            NodeNameGenerator generator;
            NodeNameGenerator[] arr$ = this.extraNodeNameGenerators;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (generatedName = (generator = arr$[i$]).getNodeName(request, basePath, requirePrefix, this.defaultNodeNameGenerator)) == null; ++i$) {
            }
        }
        if (generatedName == null) {
            generatedName = this.defaultNodeNameGenerator.getNodeName(request, basePath, requirePrefix, this.defaultNodeNameGenerator);
        }
        basePath = basePath + "/" + generatedName;
        basePath = this.ensureUniquePath(request, basePath);
        return basePath;
    }

    private String ensureUniquePath(SlingHttpServletRequest request, String basePath) throws RepositoryException {
        String jcrPath;
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        if (session.itemExists(jcrPath = this.removeAndValidateWorkspace(basePath, session))) {
            for (int idx = 0; idx < 1000; ++idx) {
                String newPath = jcrPath + "_" + idx;
                if (session.itemExists(newPath)) continue;
                basePath = basePath + "_" + idx;
                jcrPath = newPath;
                break;
            }
        }
        if (session.itemExists(jcrPath)) {
            throw new RepositoryException("Collision in generated node names for path=" + basePath);
        }
        return basePath;
    }
}

