/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.servlets.post.AbstractSlingPostOperation;
import org.apache.sling.servlets.post.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckoutOperation
extends AbstractSlingPostOperation {
    @Override
    protected void doRun(SlingHttpServletRequest request, HtmlResponse response, List<Modification> changes) throws RepositoryException {
        Iterator<Resource> res = this.getApplyToResources(request);
        if (res == null) {
            Resource resource = request.getResource();
            Node node = (Node)resource.adaptTo(Node.class);
            if (node == null) {
                response.setStatus(404, "Missing source " + resource + " for checkout");
                return;
            }
            node.checkout();
            changes.add(Modification.onCheckout(resource.getPath()));
        } else {
            while (res.hasNext()) {
                Resource resource = res.next();
                Node node = (Node)resource.adaptTo(Node.class);
                if (node == null) continue;
                node.checkout();
                changes.add(Modification.onCheckout(resource.getPath()));
            }
        }
    }

    @Override
    protected boolean isSkipCheckin(SlingHttpServletRequest request) {
        return true;
    }
}

