/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.operations.AbstractCopyMoveOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOperation
extends AbstractCopyMoveOperation {
    @Override
    protected String getOperationName() {
        return "copy";
    }

    @Override
    protected Item execute(List<Modification> changes, Item source, String destParent, String destName, VersioningConfiguration versioningConfiguration) throws RepositoryException {
        Item destItem = CopyOperation.copy(source, (Node)source.getSession().getItem(destParent), destName);
        String dest = destParent + "/" + destName;
        changes.add(Modification.onCopied(source.getPath(), dest));
        this.log.debug("copy {} to {}", (Object)source, (Object)dest);
        return destItem;
    }

    static Item copy(Item src, Node dstParent, String name) throws RepositoryException {
        if (src.isNode()) {
            return CopyOperation.copy((Node)src, dstParent, name);
        }
        return CopyOperation.copy((Property)src, dstParent, name);
    }

    static Item copy(Node src, Node dstParent, String name) throws RepositoryException {
        if (name == null) {
            name = src.getName();
        }
        if (dstParent.hasNode(name)) {
            dstParent.getNode(name).remove();
        }
        Node dst = dstParent.addNode(name, src.getPrimaryNodeType().getName());
        for (NodeType mix : src.getMixinNodeTypes()) {
            dst.addMixin(mix.getName());
        }
        PropertyIterator iter = src.getProperties();
        while (iter.hasNext()) {
            CopyOperation.copy(iter.nextProperty(), dst, null);
        }
        iter = src.getNodes();
        while (iter.hasNext()) {
            Node n = iter.nextNode();
            if (n.getDefinition().isProtected()) continue;
            CopyOperation.copy(n, dst, null);
        }
        return dst;
    }

    static Item copy(Property src, Node dstParent, String name) throws RepositoryException {
        if (!src.getDefinition().isProtected()) {
            if (name == null) {
                name = src.getName();
            }
            if (dstParent.hasProperty(name)) {
                dstParent.getProperty(name).remove();
            }
            if (src.getDefinition().isMultiple()) {
                return dstParent.setProperty(name, src.getValues());
            }
            return dstParent.setProperty(name, src.getValue());
        }
        return null;
    }
}

