/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.servlets.post.AbstractSlingPostOperation;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.VersioningConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteOperation
extends AbstractSlingPostOperation {
    @Override
    protected void doRun(SlingHttpServletRequest request, HtmlResponse response, List<Modification> changes) throws RepositoryException {
        VersioningConfiguration versioningConfiguration = this.getVersioningConfiguration(request);
        Iterator<Resource> res = this.getApplyToResources(request);
        if (res == null) {
            Resource resource = request.getResource();
            Item item = (Item)resource.adaptTo(Item.class);
            if (item == null) {
                response.setStatus(404, "Missing source " + resource + " for delete");
                return;
            }
            this.checkoutIfNecessary(item.getParent(), changes, versioningConfiguration);
            item.remove();
            changes.add(Modification.onDeleted(resource.getPath()));
        } else {
            while (res.hasNext()) {
                Resource resource = res.next();
                Item item = (Item)resource.adaptTo(Item.class);
                if (item == null) continue;
                this.checkoutIfNecessary(item.getParent(), changes, versioningConfiguration);
                item.remove();
                changes.add(Modification.onDeleted(resource.getPath()));
            }
        }
    }
}

