/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.jcr.contentloader.ContentImportListener;
import org.apache.sling.jcr.contentloader.ContentImporter;
import org.apache.sling.jcr.contentloader.ImportOptions;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.ModificationType;
import org.apache.sling.servlets.post.NodeNameGenerator;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.apache.sling.servlets.post.impl.operations.AbstractCreateOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportOperation
extends AbstractCreateOperation {
    private ContentImporter contentImporter;

    public ImportOperation(NodeNameGenerator defaultNodeNameGenerator, ContentImporter contentImporter) {
        super(defaultNodeNameGenerator);
        this.contentImporter = contentImporter;
    }

    public void setContentImporter(ContentImporter importer) {
        this.contentImporter = importer;
    }

    @Override
    protected void doRun(SlingHttpServletRequest request, HtmlResponse response, final List<Modification> changes) throws RepositoryException {
        String contentRootName;
        ContentImporter importer = this.contentImporter;
        if (importer == null) {
            response.setStatus(500, "Missing content importer for import");
            return;
        }
        Map<String, RequestProperty> reqProperties = this.collectContent(request, response);
        VersioningConfiguration versioningConfiguration = this.getVersioningConfiguration(request);
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        this.processCreate(session, reqProperties, response, changes, versioningConfiguration);
        String path = response.getPath();
        Node node = null;
        try {
            node = (Node)session.getItem(path);
        }
        catch (RepositoryException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        catch (ClassCastException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        if (node == null) {
            response.setStatus(404, "Missing target node " + path + " for import");
            return;
        }
        String contentType = request.getParameter(":contentType");
        if (contentType == null) {
            response.setStatus(412, "Required :contentType parameter is missing");
            return;
        }
        final boolean replace = "true".equalsIgnoreCase(request.getParameter(":replace"));
        final boolean replaceProperties = "true".equalsIgnoreCase(request.getParameter(":replaceProperties"));
        final boolean checkin = "true".equalsIgnoreCase(request.getParameter(":checkin"));
        String basePath = this.getItemPath(request);
        if ((basePath = this.removeAndValidateWorkspace(basePath, (Session)request.getResourceResolver().adaptTo(Session.class))).endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        if (request.getParameter(":name") != null || request.getParameter(":nameHint") != null) {
            String nodePath = this.generateName(request, basePath);
            String name = nodePath.substring(nodePath.lastIndexOf(47) + 1);
            contentRootName = name + "." + contentType;
        } else {
            contentRootName = "." + contentType;
        }
        response.setCreateRequest(true);
        try {
            Modification modification;
            InputStream contentStream = null;
            String content = request.getParameter(":content");
            if (content != null) {
                contentStream = new ByteArrayInputStream(content.getBytes());
            } else {
                RequestParameter contentFile = request.getRequestParameter(":contentFile");
                if (contentFile != null) {
                    contentStream = contentFile.getInputStream();
                }
            }
            if (contentStream == null) {
                response.setStatus(412, "Missing content for import");
                return;
            }
            importer.importContent(node, contentRootName, contentStream, new ImportOptions(){

                public boolean isCheckin() {
                    return checkin;
                }

                public boolean isIgnoredImportProvider(String extension) {
                    return false;
                }

                public boolean isOverwrite() {
                    return replace;
                }

                public boolean isPropertyOverwrite() {
                    return replaceProperties;
                }
            }, new ContentImportListener(){

                public void onReorder(String orderedPath, String beforeSibbling) {
                    changes.add(Modification.onOrder(orderedPath, beforeSibbling));
                }

                public void onMove(String srcPath, String destPath) {
                    changes.add(Modification.onMoved(srcPath, destPath));
                }

                public void onModify(String srcPath) {
                    changes.add(Modification.onModified(srcPath));
                }

                public void onDelete(String srcPath) {
                    changes.add(Modification.onDeleted(srcPath));
                }

                public void onCreate(String srcPath) {
                    changes.add(Modification.onCreated(srcPath));
                }

                public void onCopy(String srcPath, String destPath) {
                    changes.add(Modification.onMoved(srcPath, destPath));
                }
            });
            if (!changes.isEmpty() && (modification = changes.get(0)).getType() == ModificationType.CREATE) {
                String importedPath = modification.getSource();
                response.setLocation(importedPath);
                response.setPath(importedPath);
                int lastSlashIndex = importedPath.lastIndexOf(47);
                if (lastSlashIndex != -1) {
                    String parentPath = importedPath.substring(0, lastSlashIndex);
                    response.setParentLocation(parentPath);
                }
            }
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

