/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.List;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.servlet.ServletContext;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.NodeNameGenerator;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.DateParser;
import org.apache.sling.servlets.post.impl.helper.ReferenceParser;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.apache.sling.servlets.post.impl.helper.SlingFileUploadHandler;
import org.apache.sling.servlets.post.impl.helper.SlingPropertyValueHandler;
import org.apache.sling.servlets.post.impl.operations.AbstractCreateOperation;
import org.apache.sling.servlets.post.impl.operations.CopyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyOperation
extends AbstractCreateOperation {
    private final DateParser dateParser;
    private final SlingFileUploadHandler uploadHandler;

    public ModifyOperation(NodeNameGenerator defaultNodeNameGenerator, DateParser dateParser, ServletContext servletContext) {
        super(defaultNodeNameGenerator);
        this.dateParser = dateParser;
        this.uploadHandler = new SlingFileUploadHandler(servletContext);
    }

    @Override
    protected void doRun(SlingHttpServletRequest request, HtmlResponse response, List<Modification> changes) throws RepositoryException {
        Map<String, RequestProperty> reqProperties = this.collectContent(request, response);
        VersioningConfiguration versioningConfiguration = this.getVersioningConfiguration(request);
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        this.processCreate(session, reqProperties, response, changes, versioningConfiguration);
        this.processMoves(session, reqProperties, changes, versioningConfiguration);
        this.processCopies(session, reqProperties, changes, versioningConfiguration);
        this.processDeletes(session, reqProperties, changes, versioningConfiguration);
        this.writeContent(session, reqProperties, changes, versioningConfiguration);
        String path = response.getPath();
        this.orderNode(request, session.getItem(path), changes);
    }

    @Override
    protected String getItemPath(SlingHttpServletRequest request) {
        String suffix;
        StringBuffer rootPathBuf = new StringBuffer();
        Resource currentResource = request.getResource();
        if (ResourceUtil.isSyntheticResource((Resource)currentResource)) {
            suffix = currentResource.getPath();
        } else {
            suffix = request.getRequestPathInfo().getSuffix();
            rootPathBuf.append(currentResource.getPath());
        }
        boolean doGenerateName = false;
        if (suffix != null) {
            int dotPos = suffix.indexOf(46);
            if (dotPos > 0 && !(currentResource instanceof NonExistingResource)) {
                suffix = suffix.substring(0, dotPos);
            }
            if (suffix.endsWith("/")) {
                suffix = suffix.substring(0, suffix.length() - "/".length());
                doGenerateName = true;
            } else if (suffix.endsWith("/*")) {
                suffix = suffix.substring(0, suffix.length() - "/*".length());
                doGenerateName = true;
            }
            rootPathBuf.append(suffix);
        }
        String path = rootPathBuf.toString();
        if (doGenerateName) {
            try {
                path = this.generateName(request, path);
            }
            catch (RepositoryException re) {
                throw new SlingException("Failed to generate name", (Throwable)re);
            }
        }
        return path;
    }

    private void processMoves(Session session, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException {
        for (RequestProperty property : reqProperties.values()) {
            if (!property.hasRepositoryMoveSource()) continue;
            this.processMovesCopiesInternal(property, true, session, reqProperties, changes, versioningConfiguration);
        }
    }

    private void processCopies(Session session, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException {
        for (RequestProperty property : reqProperties.values()) {
            if (!property.hasRepositoryCopySource()) continue;
            this.processMovesCopiesInternal(property, false, session, reqProperties, changes, versioningConfiguration);
        }
    }

    private void processMovesCopiesInternal(RequestProperty property, boolean isMove, Session session, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException {
        String propPath = property.getPath();
        String source = property.getRepositorySource();
        if (session.itemExists(source)) {
            Node parent;
            if (session.itemExists(propPath)) {
                parent = session.getItem(propPath).getParent();
                this.checkoutIfNecessary(parent, changes, versioningConfiguration);
                session.getItem(propPath).remove();
                changes.add(Modification.onDeleted(propPath));
            } else {
                parent = this.deepGetOrCreateNode(session, property.getParentPath(), reqProperties, changes, versioningConfiguration);
                this.checkoutIfNecessary(parent, changes, versioningConfiguration);
            }
            Item sourceItem = session.getItem(source);
            if (sourceItem.isNode()) {
                if (isMove) {
                    this.checkoutIfNecessary(sourceItem.getParent(), changes, versioningConfiguration);
                    session.move(source, propPath);
                } else {
                    Node sourceNode = (Node)sourceItem;
                    Node destParent = (Node)session.getItem(property.getParentPath());
                    this.checkoutIfNecessary(destParent, changes, versioningConfiguration);
                    CopyOperation.copy(sourceNode, destParent, property.getName());
                }
            } else {
                Property sourceProperty = (Property)sourceItem;
                Node destParent = (Node)session.getItem(property.getParentPath());
                this.checkoutIfNecessary(destParent, changes, versioningConfiguration);
                CopyOperation.copy(sourceProperty, destParent, null);
                if (isMove) {
                    this.checkoutIfNecessary(sourceProperty.getParent(), changes, versioningConfiguration);
                    sourceProperty.remove();
                }
            }
            property.setDelete(false);
            if (isMove) {
                changes.add(Modification.onMoved(source, propPath));
            } else {
                changes.add(Modification.onCopied(source, propPath));
            }
        }
    }

    private void processDeletes(Session session, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException {
        for (RequestProperty property : reqProperties.values()) {
            if (!property.isDelete() || !session.itemExists(property.getPath())) continue;
            Node parent = (Node)session.getItem(property.getParentPath());
            this.checkoutIfNecessary(parent, changes, versioningConfiguration);
            if (property.getName().equals("jcr:mixinTypes")) {
                for (NodeType mixin : parent.getMixinNodeTypes()) {
                    parent.removeMixin(mixin.getName());
                }
            } else {
                session.getItem(property.getPath()).remove();
            }
            changes.add(Modification.onDeleted(property.getPath()));
        }
    }

    private void writeContent(Session session, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException {
        SlingPropertyValueHandler propHandler = new SlingPropertyValueHandler(this.dateParser, new ReferenceParser(session), changes);
        for (RequestProperty prop : reqProperties.values()) {
            if (!prop.hasValues()) continue;
            Node parent = this.deepGetOrCreateNode(session, prop.getParentPath(), reqProperties, changes, versioningConfiguration);
            this.checkoutIfNecessary(parent, changes, versioningConfiguration);
            if (prop.getName().equals("jcr:primaryType") || prop.getName().equals("jcr:mixinTypes")) continue;
            if (prop.isFileUpload()) {
                this.uploadHandler.setFile(parent, prop, changes);
                continue;
            }
            propHandler.setProperty(parent, prop);
        }
    }
}

