/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.util.ArrayList;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.post.impl.helper.Chunk;

public class RequestProperty {
    private static final RequestParameter[] EMPTY_PARAM_ARRAY = new RequestParameter[0];
    public static final String DEFAULT_IGNORE = ":ignore";
    public static final String DEFAULT_NULL = ":null";
    private final String path;
    private final String name;
    private final String parentPath;
    private RequestParameter[] values;
    private String[] stringValues;
    private String typeHint;
    private boolean hasMultiValueTypeHint;
    private RequestParameter[] defaultValues = EMPTY_PARAM_ARRAY;
    private boolean isDelete;
    private String repositoryResourcePath;
    private boolean isRepositoryResourceMove;
    private boolean ignoreBlanks;
    private boolean useDefaultWhenMissing;
    private boolean patch = false;
    private Chunk chunk;

    public RequestProperty(String path) {
        assert (path.startsWith("/"));
        this.path = ResourceUtil.normalize((String)path);
        this.parentPath = ResourceUtil.getParent((String)path);
        this.name = ResourceUtil.getName((String)path);
    }

    public String getTypeHint() {
        return this.typeHint;
    }

    public boolean hasMultiValueTypeHint() {
        return this.hasMultiValueTypeHint;
    }

    public void setTypeHintValue(String typeHint) {
        if (typeHint != null && typeHint.endsWith("[]")) {
            this.typeHint = typeHint.substring(0, typeHint.length() - 2);
            this.hasMultiValueTypeHint = true;
        } else {
            this.typeHint = typeHint;
            this.hasMultiValueTypeHint = false;
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public boolean hasValues() {
        if (this.useDefaultWhenMissing && this.defaultValues != null && this.defaultValues.length > 0) {
            return true;
        }
        if (this.ignoreBlanks) {
            return this.values != null && this.getStringValues().length > 0;
        }
        return this.values != null;
    }

    public RequestParameter[] getValues() {
        return this.values;
    }

    public void setValues(RequestParameter[] values) {
        this.values = values;
    }

    public RequestParameter[] getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(RequestParameter[] defaultValues) {
        this.defaultValues = defaultValues == null ? EMPTY_PARAM_ARRAY : defaultValues;
    }

    public boolean isFileUpload() {
        return this.values != null && !this.values[0].isFormField();
    }

    public boolean providesValue() {
        String[] sv = this.getStringValues();
        if (sv == null) {
            return true;
        }
        for (String s : sv) {
            if (s.equals("")) continue;
            return true;
        }
        return false;
    }

    public String[] getStringValues() {
        if (this.stringValues == null) {
            if (this.values == null && this.useDefaultWhenMissing) {
                this.stringValues = new String[]{this.defaultValues[0].getString()};
            } else if (this.values.length > 1) {
                ArrayList<String> stringValueList = new ArrayList<String>(this.values.length);
                for (int i = 0; i < this.values.length; ++i) {
                    String value = this.values[i].getString();
                    if (this.ignoreBlanks && value.length() <= 0) continue;
                    stringValueList.add(value);
                }
                this.stringValues = stringValueList.toArray(new String[stringValueList.size()]);
            } else {
                String value = this.values[0].getString();
                if (value.equals("")) {
                    if (this.ignoreBlanks) {
                        return new String[0];
                    }
                    if (this.defaultValues.length == 1) {
                        String defValue = this.defaultValues[0].getString();
                        if (defValue.equals(DEFAULT_IGNORE)) {
                            return new String[0];
                        }
                        if (defValue.equals(DEFAULT_NULL)) {
                            return null;
                        }
                        value = defValue;
                    }
                }
                this.stringValues = new String[]{value};
            }
        }
        return this.stringValues;
    }

    public void setDelete(boolean isDelete) {
        this.isDelete = isDelete;
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public void setRepositorySource(String sourcePath, boolean isMove) {
        if (!sourcePath.startsWith("/")) {
            sourcePath = this.getParentPath() + "/" + sourcePath;
            sourcePath = ResourceUtil.normalize((String)sourcePath);
        }
        this.repositoryResourcePath = sourcePath;
        this.isRepositoryResourceMove = isMove;
    }

    public boolean hasRepositoryMoveSource() {
        return this.isRepositoryResourceMove;
    }

    public boolean hasRepositoryCopySource() {
        return this.getRepositorySource() != null && !this.hasRepositoryMoveSource();
    }

    public String getRepositorySource() {
        return this.repositoryResourcePath;
    }

    public void setIgnoreBlanks(boolean b) {
        this.ignoreBlanks = b;
    }

    public void setUseDefaultWhenMissing(boolean b) {
        this.useDefaultWhenMissing = b;
    }

    public void setPatch(boolean b) {
        this.patch = b;
    }

    public boolean isPatch() {
        return this.patch;
    }

    public boolean isChunkUpload() {
        return this.chunk != null;
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public void setChunk(Chunk chunk) {
        this.chunk = chunk;
    }
}

