/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.operations.AbstractCopyMoveOperation;

public class CopyOperation
extends AbstractCopyMoveOperation {
    @Override
    protected String getOperationName() {
        return "copy";
    }

    @Override
    protected Resource execute(List<Modification> changes, Resource source, String destParent, String destName, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        Resource parentRsrc = source.getResourceResolver().getResource(destParent);
        Object item = this.jcrSsupport.getItem(source);
        Object parentItem = this.jcrSsupport.getNode(parentRsrc);
        if (item == null || parentItem == null) {
            Resource result = this.copy(source, parentRsrc);
            changes.add(Modification.onCopied(source.getPath(), result.getPath()));
            return result;
        }
        String dest = this.jcrSsupport.copy(item, parentItem, destName);
        changes.add(Modification.onCopied(source.getPath(), dest));
        this.log.debug("copy {} to {}", (Object)source, (Object)dest);
        return source.getResourceResolver().getResource(dest);
    }

    private Resource copy(Resource source, Resource dest) throws PersistenceException {
        ValueMap vm = source.getValueMap();
        Resource result = source.getResourceResolver().create(dest, source.getName(), (Map)vm);
        for (Resource c : source.getChildren()) {
            this.copy(c, result);
        }
        return result;
    }
}

