/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.helper.JCRSupport;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.apache.sling.servlets.post.impl.jackrabbit.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingFileUploadHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile ServletContext servletContext;
    private final JCRSupport jcrSupport = JCRSupport.INSTANCE;
    private static final String MT_APP_OCTET = "application/octet-stream";

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private void setFile(Resource parentResource, RequestProperty prop, RequestParameter value, List<Modification> changes, String name, String contentType) throws PersistenceException {
        Resource resParent;
        boolean createNtFile = parentResource.isResourceType("nt:folder") || this.jcrSupport.isNodeType(parentResource, "nt:folder");
        String typeHint = prop.getTypeHint();
        if (typeHint != null) {
            Boolean isFileNodeType = this.jcrSupport.isFileNodeType(parentResource.getResourceResolver(), typeHint);
            if (isFileNodeType == null) {
                createNtFile = false;
                typeHint = null;
            } else {
                createNtFile = isFileNodeType;
            }
        }
        if (!createNtFile && name.indexOf(46) > 0) {
            createNtFile = true;
        }
        if (typeHint == null) {
            String string = typeHint = createNtFile ? "nt:file" : "nt:resource";
        }
        if (createNtFile) {
            resParent = this.getOrCreateChildResource(parentResource, name, typeHint, changes);
            name = "jcr:content";
            typeHint = "nt:resource";
        } else {
            resParent = parentResource;
        }
        Resource newResource = this.getOrCreateChildResource(resParent, name, typeHint, changes);
        ModifiableValueMap mvm = (ModifiableValueMap)newResource.adaptTo(ModifiableValueMap.class);
        mvm.put((Object)"jcr:lastModified", (Object)Calendar.getInstance());
        mvm.put((Object)"jcr:mimeType", (Object)contentType);
        changes.add(Modification.onModified(newResource.getPath() + "/" + "jcr:lastModified"));
        changes.add(Modification.onModified(newResource.getPath() + "/" + "jcr:mimeType"));
        try {
            if (prop.isChunkUpload()) {
                this.processChunk(resParent, newResource, prop, value, changes);
            } else {
                mvm.put((Object)"jcr:data", (Object)value.getInputStream());
                changes.add(Modification.onModified(newResource.getPath() + "/" + "jcr:data"));
            }
        }
        catch (IOException e) {
            throw new PersistenceException("Error while retrieving inputstream from parameter value.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChunk(Resource resParent, Resource res, RequestProperty prop, RequestParameter value, List<Modification> changes) throws PersistenceException {
        block24: {
            try {
                FilteringResourceIterator itr;
                ModifiableValueMap mvm = (ModifiableValueMap)res.adaptTo(ModifiableValueMap.class);
                long chunkOffset = prop.getChunk().getOffset();
                if (chunkOffset == 0L) {
                    FilteringResourceIterator itr2 = new FilteringResourceIterator(res.listChildren(), "chunk");
                    if (itr2.hasNext()) {
                        throw new PersistenceException("Chunk upload already in progress at {" + res.getPath() + "}");
                    }
                    this.addChunkMixin(mvm);
                    mvm.put((Object)"sling:length", (Object)0);
                    changes.add(Modification.onModified(res.getPath() + "/" + "sling:length"));
                    if (mvm.get((Object)"jcr:data") == null) {
                        mvm.put((Object)"jcr:data", (Object)new ByteArrayInputStream("".getBytes()));
                    }
                }
                if (mvm.get((Object)"sling:length") == null) {
                    throw new PersistenceException("no chunk upload found at {" + res.getPath() + "}");
                }
                long currentLength = (Long)mvm.get("sling:length", Long.class);
                long totalLength = prop.getChunk().getLength();
                if (chunkOffset != currentLength) {
                    throw new PersistenceException("Chunk's offset {" + chunkOffset + "} doesn't match expected offset {" + currentLength + "}");
                }
                if (totalLength != 0L) {
                    if (mvm.get((Object)"sling:fileLength") != null) {
                        long expectedLength = (Long)mvm.get("sling:fileLength", Long.class);
                        if (totalLength != expectedLength) {
                            throw new PersistenceException("File length {" + totalLength + "} doesn't match expected length {" + expectedLength + "}");
                        }
                    } else {
                        mvm.put((Object)"sling:fileLength", (Object)totalLength);
                    }
                }
                if ((itr = new FilteringResourceIterator(res.listChildren(), "chunk_" + String.valueOf(chunkOffset))).hasNext()) {
                    throw new PersistenceException("Chunk already present at {" + ((Resource)itr.next()).getPath() + "}");
                }
                String nodeName = "chunk_" + String.valueOf(chunkOffset) + "_" + String.valueOf(chunkOffset + value.getSize() - 1L);
                if (totalLength == currentLength + value.getSize() || prop.getChunk().isCompleted()) {
                    File file = null;
                    InputStream fileIns = null;
                    try {
                        file = this.mergeChunks(res, value.getInputStream());
                        fileIns = new FileInputStream(file);
                        mvm.put((Object)"jcr:data", (Object)fileIns);
                        changes.add(Modification.onModified(res.getPath() + "/" + "jcr:data"));
                        FilteringResourceIterator rsrcItr = new FilteringResourceIterator(res.listChildren(), "chunk");
                        while (rsrcItr.hasNext()) {
                            Resource rsrcRange = (Resource)rsrcItr.next();
                            changes.add(Modification.onDeleted(rsrcRange.getPath()));
                            rsrcRange.getResourceResolver().delete(rsrcRange);
                        }
                        if (mvm.get((Object)"sling:fileLength") != null) {
                            changes.add(Modification.onDeleted(res.getPath() + "/" + "sling:fileLength"));
                            mvm.remove((Object)"sling:fileLength");
                        }
                        if (mvm.get((Object)"sling:length") != null) {
                            changes.add(Modification.onDeleted(res.getPath() + "/" + "sling:length"));
                            mvm.remove((Object)"sling:length");
                        }
                        this.removeChunkMixin(mvm);
                        break block24;
                    }
                    finally {
                        try {
                            fileIns.close();
                            file.delete();
                        }
                        catch (IOException rsrcItr) {}
                    }
                }
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("jcr:data", value.getInputStream());
                props.put("sling:offset", chunkOffset);
                props.put("sling:length", currentLength + value.getSize());
                for (String key : props.keySet()) {
                    changes.add(Modification.onModified(res.getPath() + "/" + nodeName + "/" + key));
                }
                props.put("sling:resourceType", "sling:chunk");
                Resource rangeRsrc = res.getResourceResolver().create(res, nodeName, props);
                changes.add(Modification.onCreated(rangeRsrc.getPath()));
            }
            catch (IOException e) {
                throw new PersistenceException("Error while retrieving inputstream from parameter value.", (Throwable)e);
            }
        }
    }

    private File mergeChunks(Resource parentResource, InputStream lastChunkStream) throws PersistenceException {
        FileOutputStream out = null;
        SequenceInputStream mergeStrm = null;
        File file = null;
        try {
            file = File.createTempFile("tmp-", "-mergechunk");
            out = new FileOutputStream(file);
            String startPattern = "chunk_0_";
            FilteringResourceIterator itr = new FilteringResourceIterator(parentResource.listChildren(), startPattern);
            LinkedHashSet<InputStream> inpStrmSet = new LinkedHashSet<InputStream>();
            while (itr.hasNext()) {
                Resource rangeResource = (Resource)itr.next();
                if (itr.hasNext()) {
                    throw new PersistenceException("more than one resource found for pattern: " + startPattern + "*");
                }
                inpStrmSet.add((InputStream)rangeResource.adaptTo(InputStream.class));
                this.log.debug("added chunk {} to merge stream", (Object)rangeResource.getName());
                String[] indexBounds = rangeResource.getName().substring("chunk_".length()).split("_");
                startPattern = "chunk_" + String.valueOf(Long.valueOf(indexBounds[1]) + 1L) + "_";
                itr = new FilteringResourceIterator(parentResource.listChildren(), startPattern);
            }
            inpStrmSet.add(lastChunkStream);
            mergeStrm = new SequenceInputStream(Collections.enumeration(inpStrmSet));
            IOUtils.copyLarge((InputStream)mergeStrm, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new PersistenceException("Exception during chunk merge occured: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(mergeStrm);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)mergeStrm);
        return file;
    }

    private Resource getChunkParent(Resource rsrc) {
        Resource chunkParent = null;
        Resource jcrContentNode = null;
        if (this.hasChunks(rsrc)) {
            chunkParent = rsrc;
        } else {
            jcrContentNode = rsrc.getChild("jcr:content");
            if (this.hasChunks(jcrContentNode)) {
                chunkParent = jcrContentNode;
            }
        }
        return chunkParent;
    }

    public void deleteChunks(Resource rsrc) throws PersistenceException {
        Resource chunkParent = this.getChunkParent(rsrc);
        if (chunkParent != null) {
            for (Resource c : new FilteringResourceIterator(rsrc.listChildren(), "chunk")) {
                c.getResourceResolver().delete(c);
            }
            ModifiableValueMap vm = (ModifiableValueMap)chunkParent.adaptTo(ModifiableValueMap.class);
            vm.remove((Object)"sling:fileLength");
            vm.remove((Object)"sling:length");
            this.removeChunkMixin(vm);
        }
    }

    private final void addChunkMixin(ModifiableValueMap vm) {
        String[] mixins = (String[])vm.get("jcr:mixinTypes", String[].class);
        if (mixins == null) {
            vm.put((Object)"jcr:mixinTypes", (Object)new String[]{"sling:chunks"});
        } else {
            HashSet<String> types = new HashSet<String>(Arrays.asList(mixins));
            if (!types.contains("sling:chunks")) {
                types.add("sling:chunks");
                vm.put((Object)"jcr:mixinTypes", (Object)types.toArray(new String[types.size()]));
            }
        }
    }

    private final void removeChunkMixin(ModifiableValueMap vm) {
        HashSet<String> types;
        String[] mixins = (String[])vm.get("jcr:mixinTypes", String[].class);
        if (mixins != null && (types = new HashSet<String>(Arrays.asList(mixins))).remove("sling:chunks")) {
            vm.put((Object)"jcr:mixinTypes", (Object)types.toArray(new String[types.size()]));
        }
    }

    public Resource getLastChunk(Resource rsrc) {
        Resource chunkParent = this.getChunkParent(rsrc);
        if (chunkParent == null) {
            return null;
        }
        Resource lastChunkRsrc = null;
        long lastChunkStartIndex = -1L;
        for (Resource chunkRsrc : new FilteringResourceIterator(rsrc.listChildren(), "chunk_")) {
            String[] indexBounds = chunkRsrc.getName().substring("chunk_".length()).split("_");
            long chunkStartIndex = Long.valueOf(indexBounds[0]);
            if (chunkStartIndex <= lastChunkStartIndex) continue;
            lastChunkRsrc = chunkRsrc;
            lastChunkStartIndex = chunkStartIndex;
        }
        return lastChunkRsrc;
    }

    private boolean hasChunks(Resource rsrc) {
        ValueMap vm = rsrc.getValueMap();
        String[] mixinTypes = (String[])vm.get("jcr:mixinTypes", String[].class);
        if (mixinTypes != null) {
            for (String nodeType : mixinTypes) {
                if (!nodeType.equals("sling:chunks")) continue;
                return true;
            }
        }
        return false;
    }

    public void setFile(Resource parent, RequestProperty prop, List<Modification> changes) throws PersistenceException {
        for (RequestParameter value : prop.getValues()) {
            int idx;
            if (value.isFormField() || value.getSize() <= 0L) continue;
            String name = prop.getName();
            if (name.equals("*")) {
                name = value.getFileName();
                name = name.substring(name.lastIndexOf(47) + 1);
                name = name.substring(name.lastIndexOf(92) + 1);
            }
            name = Text.escapeIllegalJcrChars(name);
            String contentType = value.getContentType();
            if (contentType != null && (idx = contentType.indexOf(59)) > 0) {
                contentType = contentType.substring(0, idx);
            }
            if (contentType == null || contentType.equals(MT_APP_OCTET)) {
                ServletContext ctx = this.servletContext;
                if (ctx != null) {
                    contentType = ctx.getMimeType(value.getFileName());
                }
                if (contentType == null) {
                    contentType = MT_APP_OCTET;
                }
            }
            this.setFile(parent, prop, value, changes, name, contentType);
        }
    }

    private Resource getOrCreateChildResource(Resource parent, String name, String typeHint, List<Modification> changes) throws PersistenceException {
        Resource result = parent.getChild(name);
        if (result != null) {
            if (!result.isResourceType(typeHint) && this.jcrSupport.isNode(result) && !this.jcrSupport.isNodeType(result, typeHint)) {
                parent.getResourceResolver().delete(result);
                result = this.createWithChanges(parent, name, typeHint, changes);
            }
        } else {
            result = this.createWithChanges(parent, name, typeHint, changes);
        }
        return result;
    }

    private Resource createWithChanges(Resource parent, String name, String typeHint, List<Modification> changes) throws PersistenceException {
        Map<String, String> properties = null;
        if (typeHint != null) {
            properties = !this.jcrSupport.isNode(parent) || !"nt:file".equals(typeHint) && !"nt:resource".equals(typeHint) ? Collections.singletonMap("sling:resourceType", typeHint) : Collections.singletonMap("jcr:primaryType", typeHint);
        }
        Resource result = parent.getResourceResolver().create(parent, name, properties);
        changes.add(Modification.onCreated(result.getPath()));
        return result;
    }

    private static final class FilteringResourceIterator
    implements Iterator<Resource>,
    Iterable<Resource> {
        private final String prefix;
        private final Iterator<Resource> iter;
        private Resource next;

        public FilteringResourceIterator(Iterator<Resource> iter, String prefix) {
            this.prefix = prefix;
            this.iter = iter;
            this.next = this.seek();
        }

        private Resource seek() {
            Resource result = null;
            while (this.iter.hasNext() && result == null) {
                Resource c = this.iter.next();
                if (!c.getName().startsWith(this.prefix)) continue;
                result = c;
            }
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Resource next() {
            Resource result = this.next;
            this.next = this.seek();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Resource> iterator() {
            return this;
        }
    }
}

