/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.operations.AbstractCopyMoveOperation;

public class MoveOperation
extends AbstractCopyMoveOperation {
    @Override
    protected String getOperationName() {
        return "move";
    }

    @Override
    protected Resource execute(List<Modification> changes, Resource source, String destParent, String destName, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        Resource destParentRsrc;
        Resource dest;
        if (destName == null) {
            destName = source.getName();
        }
        if ((dest = (destParentRsrc = source.getResourceResolver().getResource(destParent)).getChild(destName)) != null) {
            source.getResourceResolver().delete(dest);
        }
        Object item = this.jcrSsupport.getItem(source);
        Object target = this.jcrSsupport.getNode(destParentRsrc);
        if (item == null || target == null) {
            this.move(source, destParentRsrc);
        } else {
            this.jcrSsupport.checkoutIfNecessary(source.getParent(), changes, versioningConfiguration);
            this.jcrSsupport.move(item, target, destName);
        }
        Resource result = destParentRsrc.getChild(destName);
        if (result != null) {
            changes.add(Modification.onMoved(source.getPath(), result.getPath()));
        }
        return result;
    }

    private void move(Resource source, Resource dest) throws PersistenceException {
        ValueMap vm = source.getValueMap();
        Resource result = source.getResourceResolver().create(dest, source.getName(), (Map)vm);
        for (Resource c : source.getChildren()) {
            this.move(c, result);
        }
        source.getResourceResolver().delete(source);
    }
}

