/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import javax.servlet.Servlet;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptResource
extends AbstractResource {
    private Resource activeResource;
    private final ResourceResolver sharedResourceResolver;
    private WeakReference<ResourceResolver> perThreadResourceResolver;

    public ScriptResource(Resource resource, ResourceResolver sharedResourceResolver) {
        this.perThreadResourceResolver = new WeakReference<ResourceResolver>(resource.getResourceResolver());
        this.sharedResourceResolver = sharedResourceResolver;
        this.activeResource = resource;
    }

    private Resource getActiveResource() {
        ResourceResolver rr;
        if (!(this.perThreadResourceResolver == null || (rr = (ResourceResolver)this.perThreadResourceResolver.get()) != null && rr.isLive())) {
            this.perThreadResourceResolver = null;
            this.activeResource = this.sharedResourceResolver.getResource(this.activeResource.getPath());
        }
        return this.activeResource;
    }

    public String getResourceType() {
        return this.getActiveResource().getResourceType();
    }

    public String getResourceSuperType() {
        return this.getActiveResource().getResourceSuperType();
    }

    public ResourceResolver getResourceResolver() {
        return this.getActiveResource().getResourceResolver();
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        Servlet s;
        if (type == Servlet.class && (s = (Servlet)super.adaptTo(type)) != null) {
            return (AdapterType)s;
        }
        return (AdapterType)this.getActiveResource().adaptTo(type);
    }

    public String getPath() {
        return this.getActiveResource().getPath();
    }

    public ResourceMetadata getResourceMetadata() {
        return this.getActiveResource().getResourceMetadata();
    }

    public String getName() {
        return this.getActiveResource().getName();
    }

    public Resource getParent() {
        return this.getActiveResource().getParent();
    }

    public Resource getChild(String relPath) {
        return this.getActiveResource().getChild(relPath);
    }

    public Iterator<Resource> listChildren() {
        return this.getActiveResource().listChildren();
    }

    public Iterable<Resource> getChildren() {
        return this.getActiveResource().getChildren();
    }

    public boolean isResourceType(String resourceType) {
        return this.getActiveResource().isResourceType(resourceType);
    }
}

