/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.helper;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationIterator
implements Iterator<String> {
    private final ResourceResolver resolver;
    private final String baseResourceType;
    private final String[] searchPath;
    private int pathCounter;
    private String resourceType;
    private final String firstResourceType;
    private final String firstResourceSuperType;
    private String relPath;
    private String nextLocation;
    private final Set<String> usedResourceTypes = new HashSet<String>();

    public LocationIterator(String resourceType, String resourceSuperType, String baseResourceType, ResourceResolver resolver) {
        this.resolver = resolver;
        this.baseResourceType = baseResourceType;
        String[] tmpPath = resolver.getSearchPath();
        if (tmpPath == null || tmpPath.length == 0) {
            tmpPath = new String[]{"/"};
        }
        this.searchPath = tmpPath;
        this.firstResourceType = resourceType;
        this.firstResourceSuperType = resourceSuperType;
        this.resourceType = this.firstResourceType;
        this.usedResourceTypes.add(this.resourceType);
        this.nextLocation = this.seek();
    }

    @Override
    public boolean hasNext() {
        return this.nextLocation != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String result = this.nextLocation;
        this.nextLocation = this.seek();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private String seek() {
        if (this.relPath == null) {
            if (this.resourceType == null) {
                return null;
            }
            String typePath = ResourceUtil.resourceTypeToPath((String)this.resourceType);
            if (typePath.startsWith("/")) {
                this.resourceType = this.getResourceSuperType(this.resourceType);
                return typePath;
            }
            this.relPath = typePath;
        }
        String result = this.searchPath[this.pathCounter].concat(this.relPath);
        ++this.pathCounter;
        if (this.pathCounter >= this.searchPath.length) {
            this.relPath = null;
            this.resourceType = this.getResourceSuperType(this.resourceType);
            this.pathCounter = 0;
        }
        return result;
    }

    private String getResourceSuperType(String resourceType) {
        if (resourceType.equals(this.baseResourceType)) {
            return null;
        }
        String superType = resourceType.equals(this.firstResourceType) && this.firstResourceSuperType != null ? this.firstResourceSuperType : this.getResourceSuperType(this.resolver, resourceType);
        if (superType != null) {
            if (this.usedResourceTypes.contains(superType)) {
                LoggerFactory.getLogger(this.getClass()).error("Circular dependency in resource type hierarchy detected! Check super types of {}", (Object)superType);
                superType = null;
            } else {
                this.usedResourceTypes.add(superType);
            }
        }
        if (superType == null) {
            superType = this.baseResourceType;
        }
        return superType;
    }

    private String getResourceSuperType(ResourceResolver resourceResolver, String resourceType) {
        String resourceSuperType;
        block2: {
            String rtPath;
            block1: {
                rtPath = ResourceUtil.resourceTypeToPath((String)resourceType);
                resourceSuperType = null;
                if (rtPath == null || !rtPath.startsWith("/")) break block1;
                String candidatePath = rtPath;
                Resource rtResource = resourceResolver.getResource(candidatePath);
                if (rtResource == null) break block2;
                resourceSuperType = rtResource.getResourceSuperType();
                break block2;
            }
            for (String searchPath : this.searchPath) {
                String candidatePath = searchPath + rtPath;
                Resource rtResource = resourceResolver.getResource(candidatePath);
                if (rtResource == null || rtResource.getResourceSuperType() == null) continue;
                resourceSuperType = rtResource.getResourceSuperType();
                break;
            }
        }
        return resourceSuperType;
    }
}

