/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.resource;

import java.util.HashSet;
import java.util.Set;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.servlets.resolver.internal.resource.ServletResourceProvider;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletResourceProviderFactory {
    public static final String SERVLET_PATH_EXTENSION = ".servlet";
    private static final String[] DEFAULT_SERVLET_METHODS = new String[]{"GET", "HEAD"};
    private static final String ALL_METHODS = "*";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String servletRoot;
    private final int servletRootIndex;
    private final String[] searchPaths;

    static String ensureServletNameExtension(String servletPath) {
        if (servletPath.endsWith(SERVLET_PATH_EXTENSION)) {
            return servletPath;
        }
        return servletPath.concat(SERVLET_PATH_EXTENSION);
    }

    public ServletResourceProviderFactory(Object servletRoot, String[] paths) {
        this.searchPaths = paths;
        String value = servletRoot.toString();
        boolean isNumber = false;
        int index = -1;
        if (servletRoot instanceof Number) {
            isNumber = true;
            index = ((Number)servletRoot).intValue();
        } else if (!value.startsWith("/")) {
            try {
                index = Integer.valueOf(value);
                isNumber = true;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (!isNumber) {
            if (!value.startsWith("/")) {
                value = "/" + value;
            }
            if (!value.endsWith("/")) {
                value = value + "/";
            }
            this.servletRoot = value;
            this.servletRootIndex = -1;
        } else {
            this.servletRoot = null;
            this.servletRootIndex = index;
        }
    }

    public ServletResourceProvider create(ServiceReference ref) {
        HashSet<String> pathSet = new HashSet<String>();
        this.addByPath(pathSet, ref);
        this.addByType(pathSet, ref);
        if (pathSet.isEmpty()) {
            if (this.log.isInfoEnabled()) {
                this.log.info("create({}): ServiceReference has no registration settings, ignoring", (Object)this.getServiceIdentifier(ref));
            }
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("create({}): Registering servlet for paths {}", (Object)this.getServiceIdentifier(ref), pathSet);
        }
        return new ServletResourceProvider(pathSet);
    }

    private String getPrefix(ServiceReference ref) {
        Object value = ref.getProperty("sling.servlet.prefix");
        if (value == null) {
            if (this.servletRoot != null) {
                return this.servletRoot;
            }
            value = this.servletRootIndex;
        }
        int index = -1;
        if (value instanceof Number) {
            index = ((Number)value).intValue();
        } else {
            String s = value.toString();
            if (!s.startsWith("/")) {
                boolean isNumber = false;
                try {
                    index = Integer.valueOf(s);
                    isNumber = true;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (!isNumber) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("getPrefix({}): Configuration property is ignored {}", (Object)this.getServiceIdentifier(ref), value);
                    }
                    if (this.servletRoot != null) {
                        return this.servletRoot;
                    }
                    index = this.servletRootIndex;
                }
            } else {
                return s;
            }
        }
        if (index == -1 || index >= this.searchPaths.length) {
            index = this.searchPaths.length - 1;
        }
        return this.searchPaths[index];
    }

    private void addByPath(Set<String> pathSet, ServiceReference ref) {
        String[] paths = OsgiUtil.toStringArray((Object)ref.getProperty("sling.servlet.paths"));
        if (paths != null && paths.length > 0) {
            for (String path : paths) {
                if (!path.startsWith("/")) {
                    path = this.getPrefix(ref).concat(path);
                }
                pathSet.add(path);
                pathSet.add(ServletResourceProviderFactory.ensureServletNameExtension(path));
            }
        }
    }

    private void addByType(Set<String> pathSet, ServiceReference ref) {
        String[] types = OsgiUtil.toStringArray((Object)ref.getProperty("sling.servlet.resourceTypes"));
        if (types == null || types.length == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("addByType({}): no resource types declared", (Object)this.getServiceIdentifier(ref));
            }
            return;
        }
        String[] selectors = OsgiUtil.toStringArray((Object)ref.getProperty("sling.servlet.selectors"));
        if (selectors == null) {
            selectors = new String[]{null};
        }
        String[] extensions = OsgiUtil.toStringArray((Object)ref.getProperty("sling.servlet.extensions"));
        String[] methods = OsgiUtil.toStringArray((Object)ref.getProperty("sling.servlet.methods"));
        if (methods == null || methods.length == 0) {
            if (extensions == null || extensions.length == 0) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("addByType({}): No methods declared, assuming GET/HEAD", (Object)this.getServiceIdentifier(ref));
                }
                methods = DEFAULT_SERVLET_METHODS;
            }
        } else if (methods.length == 1 && ALL_METHODS.equals(methods[0])) {
            if (this.log.isInfoEnabled()) {
                this.log.info("addByType({}): Assuming all methods for '*'", (Object)this.getServiceIdentifier(ref));
            }
            methods = null;
        }
        for (String type : types) {
            if (!(type = ResourceUtil.resourceTypeToPath((String)type)).startsWith("/")) {
                type = this.getPrefix(ref) + type;
            }
            if (!type.endsWith("/")) {
                type = type + "/";
            }
            for (String selector : selectors) {
                String selPath = type;
                if (selector != null && selector.length() > 0) {
                    selPath = selPath + selector.replace('.', '/') + ".";
                }
                boolean pathAdded = false;
                if (extensions != null) {
                    if (methods != null) {
                        for (String ext : extensions) {
                            for (String method : methods) {
                                pathSet.add(selPath + ext + "." + method + SERVLET_PATH_EXTENSION);
                                pathAdded = true;
                            }
                        }
                    } else {
                        for (String ext : extensions) {
                            pathSet.add(selPath + ext + SERVLET_PATH_EXTENSION);
                            pathAdded = true;
                        }
                    }
                } else if (methods != null) {
                    for (String method : methods) {
                        pathSet.add(selPath + method + SERVLET_PATH_EXTENSION);
                        pathAdded = true;
                    }
                }
                if (pathAdded) continue;
                pathSet.add(selPath.substring(0, selPath.length() - 1) + SERVLET_PATH_EXTENSION);
            }
        }
    }

    private String getServiceIdentifier(ServiceReference ref) {
        Object id = ref.getProperty("component.name");
        if (id != null) {
            return id.toString();
        }
        id = ref.getProperty("service.pid");
        if (id != null) {
            return id.toString();
        }
        return ref.getProperty("service.id").toString();
    }
}

