/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.wrappers.IteratorWrapper;
import org.apache.sling.api.wrappers.ResourceResolverWrapper;
import org.apache.sling.servlets.resolver.internal.resource.MergingServletResourceProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;

public class ScriptResourceResolver
extends ResourceResolverWrapper {
    private final ResourceResolver resolver;
    private final Supplier<MergingServletResourceProvider> provider;

    public ScriptResourceResolver(ResourceResolver resolver, Supplier<MergingServletResourceProvider> provider) {
        super(resolver);
        this.resolver = resolver;
        this.provider = provider;
    }

    public static ScriptResourceResolver wrap(ResourceResolver scriptResourceResolver, Supplier<MergingServletResourceProvider> provider) {
        return new ScriptResourceResolver(scriptResourceResolver, provider);
    }

    public Iterable<Resource> getChildren(Resource parent) {
        return () -> this.listChildren(parent);
    }

    public Resource getResource(String scriptPath) {
        MergingServletResourceProvider provider = this.provider.get();
        if (provider == null) {
            return super.getResource(scriptPath);
        }
        return this.wrap(provider.getResource(new ResolveContext(){

            public ResourceResolver getResourceResolver() {
                return ScriptResourceResolver.this;
            }

            public Object getProviderState() {
                return null;
            }

            public ResolveContext<?> getParentResolveContext() {
                return null;
            }

            public ResourceProvider<?> getParentResourceProvider() {
                return new ResourceProvider(){

                    public Resource getResource(ResolveContext ctx, String path, ResourceContext resourceContext, Resource parent) {
                        return ScriptResourceResolver.this.resolver.getResource(path);
                    }

                    public Iterator<Resource> listChildren(ResolveContext ctx, Resource parent) {
                        return ScriptResourceResolver.this.resolver.listChildren(parent);
                    }
                };
            }
        }, scriptPath));
    }

    public Resource getResource(Resource base, @NotNull String path) {
        if (!path.startsWith("/") && base != null) {
            path = base.getPath() + "/" + path;
        }
        return this.getResource(path);
    }

    public Iterator<Resource> listChildren(Resource parent) {
        MergingServletResourceProvider provider = this.provider.get();
        if (provider == null) {
            return super.listChildren(parent);
        }
        return this.wrap(provider.listChildren(new ResolveContext(){

            public ResourceResolver getResourceResolver() {
                return ScriptResourceResolver.this;
            }

            public Object getProviderState() {
                return null;
            }

            public ResolveContext<?> getParentResolveContext() {
                return null;
            }

            public ResourceProvider<?> getParentResourceProvider() {
                return new ResourceProvider(){

                    public Resource getResource(ResolveContext ctx, String path, ResourceContext resourceContext, Resource parent) {
                        return ScriptResourceResolver.this.resolver.getResource(path);
                    }

                    public Iterator<Resource> listChildren(ResolveContext ctx, Resource parent) {
                        return ScriptResourceResolver.this.resolver.listChildren(parent);
                    }
                };
            }
        }, this.unwrap(parent)));
    }

    private Resource wrap(Resource resource) {
        if (resource != null && !(resource.getResourceResolver() instanceof ScriptResourceResolver)) {
            resource = new ScriptResourceResolverResourceWrapper((Resource)resource);
        }
        return resource;
    }

    private Iterator<Resource> wrap(Iterator<Resource> iter) {
        if (iter != null) {
            iter = new IteratorWrapper<Resource>(iter){

                public Resource next() {
                    return ScriptResourceResolver.this.wrap((Resource)super.next());
                }
            };
        }
        return iter;
    }

    private Resource unwrap(Resource resource) {
        if (resource instanceof ScriptResourceResolverResourceWrapper) {
            resource = ((ResourceWrapper)resource).getResource();
        }
        return resource;
    }

    public ScriptResourceResolver clone(Map o) throws LoginException {
        return ScriptResourceResolver.wrap(this.resolver.clone(o), this.provider);
    }

    private class ScriptResourceResolverResourceWrapper
    extends ResourceWrapper {
        public ScriptResourceResolverResourceWrapper(Resource resource) {
            super(resource);
        }

        public ResourceResolver getResourceResolver() {
            return ScriptResourceResolver.this;
        }
    }
}

