/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.servlets.resolver.internal.ResolverConfig;
import org.apache.sling.servlets.resolver.internal.SlingServletResolver;
import org.apache.sling.servlets.resolver.internal.engine.SlingRequestPathInfo;
import org.apache.sling.servlets.resolver.internal.helper.ResourceCollector;
import org.apache.sling.servlets.resolver.internal.resolution.ResolutionCache;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, configurationPid={"org.apache.sling.servlets.resolver.SlingServletResolver"}, property={"service.description=Sling Servlet Resolver Web Console Plugin", "service.vendor=The Apache Software Foundation", "felix.webconsole.label=servletresolver", "felix.webconsole.title=Sling Servlet Resolver", "felix.webconsole.css=/servletresolver/res/ui/styles.css", "felix.webconsole.category=Sling"})
public class WebConsolePlugin
extends HttpServlet {
    private static final String PARAMETER_URL = "url";
    private static final String PARAMETER_METHOD = "method";
    private static final String SERVICE_USER_CONSOLE = "console";
    @Reference(target="(subServiceName=console)")
    private ServiceUserMapped consoleServiceUserMapped;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ResolutionCache resolutionCache;
    private volatile String[] executionPaths;
    private volatile String[] defaultExtensions;

    @Activate
    @Modified
    protected void activate(ResolverConfig config) {
        this.executionPaths = SlingServletResolver.getExecutionPaths(config.servletresolver_paths());
        this.defaultExtensions = config.servletresolver_defaultExtensions();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String url = request.getParameter(PARAMETER_URL);
        RequestPathInfo requestPathInfo = WebConsolePlugin.getRequestPathInfo(url);
        String method = request.getParameter(PARAMETER_METHOD);
        if (StringUtils.isBlank((CharSequence)method)) {
            method = "GET";
        }
        String CONSOLE_PATH_WARNING = "<em>Note that in a real Sling request, the path might vary depending on the existence of resources that partially match it.<br/>This utility does not take this into account and uses the first dot to split between path and selectors/extension.<br/>As a workaround, you can replace dots with underline characters, for example, when testing such an URL.</em>";
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", SERVICE_USER_CONSOLE));){
            PrintWriter pw = response.getWriter();
            pw.print("<form method='get'>");
            pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
            this.titleHtml(pw, "Servlet Resolver Test", "To check which servlet is responsible for rendering a response, enter a request path into the field and click 'Resolve' to resolve it.");
            this.tr(pw);
            this.tdLabel(pw, "URL");
            this.tdContent(pw);
            pw.print("<input type='text' name='");
            pw.print(PARAMETER_URL);
            pw.print("' value='");
            if (url != null) {
                pw.print(ResponseUtil.escapeXml((String)url));
            }
            pw.println("' class='input' size='50'>");
            this.closeTd(pw);
            this.closeTr(pw);
            this.closeTr(pw);
            this.tr(pw);
            this.tdLabel(pw, "Method");
            this.tdContent(pw);
            pw.print("<select name='");
            pw.print(PARAMETER_METHOD);
            pw.println("'>");
            pw.println("<option value='GET'>GET</option>");
            pw.println("<option value='POST'>POST</option>");
            pw.println("</select>");
            pw.println("&nbsp;&nbsp;<input type='submit' value='Resolve' class='submit'>");
            this.closeTd(pw);
            this.closeTr(pw);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                this.tr(pw);
                this.tdLabel(pw, "Decomposed URL");
                this.tdContent(pw);
                pw.println("<dl>");
                pw.println("<dt>Path</dt>");
                pw.print("<dd>");
                pw.print(ResponseUtil.escapeXml((String)requestPathInfo.getResourcePath()));
                pw.print("<br/>");
                pw.print("<em>Note that in a real Sling request, the path might vary depending on the existence of resources that partially match it.<br/>This utility does not take this into account and uses the first dot to split between path and selectors/extension.<br/>As a workaround, you can replace dots with underline characters, for example, when testing such an URL.</em>");
                pw.println("</dd>");
                pw.println("<dt>Selectors</dt>");
                pw.print("<dd>");
                if (requestPathInfo.getSelectors().length == 0) {
                    pw.print("&lt;none&gt;");
                } else {
                    pw.print("[");
                    pw.print(ResponseUtil.escapeXml((String)StringUtils.join((Object[])requestPathInfo.getSelectors(), (String)", ")));
                    pw.print("]");
                }
                pw.println("</dd>");
                pw.println("<dt>Extension</dt>");
                pw.print("<dd>");
                pw.print(ResponseUtil.escapeXml((String)requestPathInfo.getExtension()));
                pw.println("</dd>");
                pw.println("</dl>");
                pw.println("</dd>");
                pw.println("<dt>Suffix</dt>");
                pw.print("<dd>");
                pw.print(ResponseUtil.escapeXml((String)requestPathInfo.getSuffix()));
                pw.println("</dd>");
                pw.println("</dl>");
                this.closeTd(pw);
                this.closeTr(pw);
            }
            if (StringUtils.isNotBlank((CharSequence)requestPathInfo.getResourcePath())) {
                Collection<Resource> servlets;
                Resource resource = resourceResolver.resolve(requestPathInfo.getResourcePath());
                if (resource.adaptTo(Servlet.class) != null) {
                    servlets = Collections.singleton(resource);
                } else {
                    ResourceCollector locationUtil = ResourceCollector.create(resource, requestPathInfo.getExtension(), this.executionPaths, this.defaultExtensions, method, requestPathInfo.getSelectors());
                    servlets = locationUtil.getServlets(resourceResolver, this.resolutionCache.getScriptEngineExtensions());
                }
                this.tr(pw);
                this.tdLabel(pw, "Candidates");
                this.tdContent(pw);
                if (servlets == null || servlets.isEmpty()) {
                    pw.println("Could not find a suitable servlet for this request!");
                } else {
                    if (ResourceUtil.isNonExistingResource((Resource)resource)) {
                        pw.println("The resource given by path '");
                        pw.println(ResponseUtil.escapeXml((String)resource.getPath()));
                        pw.println("' does not exist. Therefore no resource type could be determined!<br/>");
                    }
                    pw.print("Candidate servlets and scripts in order of preference for method ");
                    pw.print(ResponseUtil.escapeXml((String)method));
                    pw.println(":<br/>");
                    pw.println("<ol class='servlets'>");
                    this.outputServlets(pw, servlets.iterator());
                    pw.println("</ol>");
                }
                pw.println("</td>");
                this.closeTr(pw);
            }
            pw.println("</table>");
            pw.print("</form>");
        }
        catch (LoginException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void tdContent(PrintWriter pw) {
        pw.print("<td class='content' colspan='2'>");
    }

    private void closeTd(PrintWriter pw) {
        pw.print("</td>");
    }

    private URL getResource(String path) {
        if (path.startsWith("/servletresolver/res/ui")) {
            return ((Object)((Object)this)).getClass().getResource(path.substring(16));
        }
        return null;
    }

    private void closeTr(PrintWriter pw) {
        pw.println("</tr>");
    }

    private void tdLabel(PrintWriter pw, String label) {
        pw.print("<td class='content'>");
        pw.print(ResponseUtil.escapeXml((String)label));
        pw.println("</td>");
    }

    private void tr(PrintWriter pw) {
        pw.println("<tr class='content'>");
    }

    private void outputServlets(PrintWriter pw, Iterator<Resource> iterator) {
        while (iterator.hasNext()) {
            Resource candidateResource = iterator.next();
            Servlet candidate = (Servlet)candidateResource.adaptTo(Servlet.class);
            if (candidate == null) continue;
            boolean allowed = SlingServletResolver.isPathAllowed(candidateResource.getPath(), this.executionPaths);
            pw.print("<li>");
            if (!allowed) {
                pw.print("<del>");
            }
            if (candidate instanceof SlingScript) {
                pw.print(ResponseUtil.escapeXml((String)candidateResource.getPath()));
            } else {
                boolean isOptingServlet = candidate instanceof OptingServlet;
                pw.print(ResponseUtil.escapeXml((String)candidate.getClass().getName()));
                if (isOptingServlet) {
                    pw.print(" (OptingServlet)");
                }
            }
            if (!allowed) {
                pw.print("</del>");
            }
            pw.println("</li>");
        }
    }

    private void titleHtml(PrintWriter pw, String title, String description) {
        this.tr(pw);
        pw.print("<th colspan='3' class='content container'>");
        pw.print(ResponseUtil.escapeXml((String)title));
        pw.println("</th>");
        this.closeTr(pw);
        if (description != null) {
            this.tr(pw);
            pw.print("<td colspan='3' class='content'>");
            pw.print(ResponseUtil.escapeXml((String)description));
            pw.println("</th>");
            this.closeTr(pw);
        }
    }

    public static RequestPathInfo getRequestPathInfo(String urlString) {
        if (urlString == null) {
            urlString = "";
        }
        String fullPath = urlString;
        if (urlString.contains("http")) {
            try {
                fullPath = new URL(urlString).getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        int firstDot = fullPath.indexOf(".");
        ResourceMetadata metadata = new ResourceMetadata();
        SyntheticResource r = new SyntheticResource(null, metadata, null);
        metadata.setResolutionPath(firstDot < 0 ? fullPath : fullPath.substring(0, firstDot));
        metadata.setResolutionPathInfo(firstDot < 0 ? null : fullPath.substring(firstDot));
        return new SlingRequestPathInfo((Resource)r);
    }
}

