/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.resolution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.servlet.Servlet;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.api.resource.path.Path;
import org.apache.sling.servlets.resolver.internal.ResolverConfig;
import org.apache.sling.servlets.resolver.internal.helper.AbstractResourceCollector;
import org.apache.sling.servlets.resolver.jmx.SlingServletResolverCacheMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.apache.sling.servlets.resolver.SlingServletResolver"}, service={ResolutionCache.class})
public class ResolutionCache
implements EventHandler,
ResourceChangeListener,
ExternalResourceChangeListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ScriptEngineManager scriptEngineManager;
    private volatile List<String> scriptEnginesExtensions = Collections.emptyList();
    private volatile Map<AbstractResourceCollector, Servlet> cache;
    private volatile int cacheSize;
    private volatile boolean logCacheSizeWarning;
    private volatile ServiceRegistration<EventHandler> eventHandlerRegistration;
    private volatile ServiceRegistration<ResourceChangeListener> resourceListenerRegistration;
    private volatile ServiceRegistration<SlingServletResolverCacheMBean> mbeanRegistration;

    @Activate
    protected void activate(BundleContext context, ResolverConfig config) throws LoginException {
        this.cacheSize = config.servletresolver_cacheSize();
        if (this.cacheSize > 5) {
            this.cache = new ConcurrentHashMap<AbstractResourceCollector, Servlet>(this.cacheSize);
            this.logCacheSizeWarning = true;
            try {
                Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
                ((Dictionary)mbeanProps).put("jmx.objectname", "org.apache.sling:type=servletResolver,service=SlingServletResolverCache");
                ServletResolverCacheMBeanImpl mbean = new ServletResolverCacheMBeanImpl();
                this.mbeanRegistration = context.registerService(SlingServletResolverCacheMBean.class, (Object)mbean, mbeanProps);
            }
            catch (Throwable t) {
                this.logger.warn("Unable to register servlets resolver cache MBean", t);
            }
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.description", "Apache Sling Servlet Resolver Event Handler");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("event.topics", new String[]{"javax/script/ScriptEngineFactory/*", "org/apache/sling/api/adapter/AdapterFactory/*", "org/apache/sling/scripting/core/BindingsValuesProvider/*"});
        this.eventHandlerRegistration = context.registerService(EventHandler.class, (Object)this, props);
        if (this.cache != null) {
            String[] listenerPaths = new String[config.servletresolver_paths().length];
            for (int i = 0; i < config.servletresolver_paths().length; ++i) {
                Path p = new Path(config.servletresolver_paths()[i]);
                listenerPaths[i] = p.getPath();
            }
            Hashtable<String, Object> listenerProps = new Hashtable<String, Object>();
            ((Dictionary)listenerProps).put("service.description", "Apache Sling Servlet Resolver Resource Listener");
            ((Dictionary)listenerProps).put("service.vendor", "The Apache Software Foundation");
            ((Dictionary)listenerProps).put("resource.paths", listenerPaths);
            this.resourceListenerRegistration = context.registerService(ResourceChangeListener.class, (Object)this, listenerProps);
        }
        this.updateScriptEngineExtensions();
    }

    @Modified
    protected void modified(BundleContext context, ResolverConfig config) throws LoginException {
        this.deactivate();
        this.activate(context, config);
    }

    @Deactivate
    protected void deactivate() {
        this.cache = null;
        if (this.mbeanRegistration != null) {
            this.mbeanRegistration.unregister();
            this.mbeanRegistration = null;
        }
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
            this.eventHandlerRegistration = null;
        }
        if (this.resourceListenerRegistration != null) {
            this.resourceListenerRegistration.unregister();
            this.resourceListenerRegistration = null;
        }
    }

    public List<String> getScriptEngineExtensions() {
        return this.scriptEnginesExtensions;
    }

    private void updateScriptEngineExtensions() {
        ScriptEngineManager localScriptEngineManager = this.scriptEngineManager;
        if (localScriptEngineManager != null) {
            ArrayList<String> scriptEnginesExtensions = new ArrayList<String>();
            for (ScriptEngineFactory factory : localScriptEngineManager.getEngineFactories()) {
                scriptEnginesExtensions.addAll(factory.getExtensions());
            }
            this.scriptEnginesExtensions = Collections.unmodifiableList(scriptEnginesExtensions);
        }
    }

    public void handleEvent(Event event) {
        if (this.eventHandlerRegistration == null) {
            return;
        }
        this.flushCache();
        this.updateScriptEngineExtensions();
    }

    public void flushCache() {
        Map<AbstractResourceCollector, Servlet> localCache = this.cache;
        if (localCache != null) {
            localCache.clear();
            this.logCacheSizeWarning = true;
        }
    }

    public void onChange(List<ResourceChange> changes) {
        if (this.resourceListenerRegistration == null || changes.isEmpty()) {
            return;
        }
        this.flushCache();
    }

    public Servlet get(AbstractResourceCollector context) {
        Map<AbstractResourceCollector, Servlet> localCache = this.cache;
        if (localCache != null) {
            return localCache.get(context);
        }
        return null;
    }

    public void put(AbstractResourceCollector context, Servlet candidate) {
        Map<AbstractResourceCollector, Servlet> localCache = this.cache;
        if (localCache != null) {
            if (localCache.size() < this.cacheSize) {
                localCache.put(context, candidate);
            } else if (this.logCacheSizeWarning) {
                this.logCacheSizeWarning = false;
                this.logger.warn("Script cache has reached its limit of {}. You might want to increase the cache size for the servlet resolver.", (Object)this.cacheSize);
            }
        }
    }

    class ServletResolverCacheMBeanImpl
    extends StandardMBean
    implements SlingServletResolverCacheMBean {
        ServletResolverCacheMBeanImpl() throws NotCompliantMBeanException {
            super(SlingServletResolverCacheMBean.class);
        }

        @Override
        public int getCacheSize() {
            Map localCache = ResolutionCache.this.cache;
            return localCache != null ? localCache.size() : 0;
        }

        @Override
        public void flushCache() {
            ResolutionCache.this.flushCache();
        }

        @Override
        public int getMaximumCacheSize() {
            return ResolutionCache.this.cacheSize;
        }
    }
}

