/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.bundle.tracker.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.servlets.resolver.bundle.tracker.BundledRenderUnitCapability;
import org.apache.sling.servlets.resolver.bundle.tracker.ResourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;

class BundledRenderUnitCapabilityImpl
implements BundledRenderUnitCapability {
    private final Set<ResourceType> resourceTypes;
    private final String path;
    private final List<String> selectors;
    private final String extension;
    private final String method;
    private final String extendedResourceType;
    private final String scriptEngineName;
    private final String scriptExtension;

    private BundledRenderUnitCapabilityImpl(@NotNull Set<ResourceType> resourceTypes, @Nullable String path, @NotNull List<String> selectors, @Nullable String extension, @Nullable String method, @Nullable String extendedResourceType, @Nullable String scriptEngineName, @Nullable String scriptExtension) {
        this.resourceTypes = resourceTypes;
        this.path = path;
        this.selectors = selectors;
        this.extension = extension;
        this.method = method;
        this.extendedResourceType = extendedResourceType;
        this.scriptEngineName = scriptEngineName;
        this.scriptExtension = scriptExtension;
    }

    @Override
    @NotNull
    public Set<ResourceType> getResourceTypes() {
        return Collections.unmodifiableSet(this.resourceTypes);
    }

    @Override
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public List<String> getSelectors() {
        return Collections.unmodifiableList(this.selectors);
    }

    @Override
    @Nullable
    public String getExtension() {
        return this.extension;
    }

    @Override
    @Nullable
    public String getExtendedResourceType() {
        return this.extendedResourceType;
    }

    @Override
    @Nullable
    public String getMethod() {
        return this.method;
    }

    @Override
    @Nullable
    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    @Override
    @Nullable
    public String getScriptExtension() {
        return this.scriptExtension;
    }

    public int hashCode() {
        return Objects.hash(this.resourceTypes, this.path, this.selectors, this.extension, this.method, this.extendedResourceType, this.scriptEngineName, this.scriptExtension);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BundledRenderUnitCapability) {
            BundledRenderUnitCapability other = (BundledRenderUnitCapability)obj;
            return Objects.equals(this.resourceTypes, other.getResourceTypes()) && Objects.equals(this.path, other.getPath()) && Objects.equals(this.selectors, other.getSelectors()) && Objects.equals(this.extension, other.getExtension()) && Objects.equals(this.method, other.getMethod()) && Objects.equals(this.extendedResourceType, other.getExtendedResourceType()) && Objects.equals(this.scriptEngineName, other.getScriptEngineName()) && Objects.equals(this.scriptExtension, other.getScriptExtension());
        }
        return false;
    }

    public static BundledRenderUnitCapability fromBundleCapability(@NotNull BundleCapability capability) {
        Map attributes = capability.getAttributes();
        LinkedHashSet<ResourceType> resourceTypes = new LinkedHashSet<ResourceType>();
        String[] capabilityResourceTypes = PropertiesUtil.toStringArray(attributes.get("sling.servlet.resourceTypes"), (String[])new String[0]);
        Version version = (Version)attributes.get("version");
        for (String rt : capabilityResourceTypes) {
            if (version == null) {
                resourceTypes.add(ResourceType.parseResourceType(rt));
                continue;
            }
            resourceTypes.add(ResourceType.parseResourceType(rt + "/" + version.toString()));
        }
        return new BundledRenderUnitCapabilityImpl(resourceTypes, (String)attributes.get("sling.servlet.paths"), Arrays.asList(PropertiesUtil.toStringArray(attributes.get("sling.servlet.selectors"), (String[])new String[0])), (String)attributes.get("sling.servlet.extensions"), (String)attributes.get("sling.servlet.methods"), (String)attributes.get("extends"), (String)attributes.get("scriptEngine"), (String)attributes.get("scriptExtension"));
    }
}

