/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.resource;

import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.servlets.resolver.bundle.tracker.internal.BundledScriptServlet;
import org.apache.sling.servlets.resolver.internal.resource.ServletResourceProviderFactory;

public class ServletResource
extends AbstractResource {
    private final ResourceResolver resourceResolver;
    private final Servlet servlet;
    private final String path;
    private final String resourceType;
    private final String resourceSuperType;
    private final ResourceMetadata metadata;
    private volatile Resource wrapped;

    public ServletResource(ResourceResolver resourceResolver, Servlet servlet, String path) {
        this(resourceResolver, servlet, path, null);
    }

    ServletResource(ResourceResolver resourceResolver, Servlet servlet, String path, String resourceSuperType) {
        this.resourceResolver = resourceResolver;
        this.servlet = servlet;
        this.path = path;
        this.resourceType = ServletResourceProviderFactory.ensureServletNameExtension(path);
        this.resourceSuperType = StringUtils.isEmpty((CharSequence)resourceSuperType) ? "sling/bundle/resource" : resourceSuperType;
        this.metadata = new ResourceMetadata();
        this.metadata.put("sling.servlet.resource", (Object)"true");
    }

    void setWrappedResource(Resource wrapped) {
        if (wrapped != null && !"sling:nonexisting".equals(wrapped.getResourceType())) {
            this.wrapped = wrapped;
        }
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceSuperType() {
        return this.resourceSuperType;
    }

    public String getPath() {
        return this.path;
    }

    private String getServletName() {
        String servletName = null;
        if (this.servlet != null) {
            if (this.servlet.getServletConfig() != null) {
                servletName = this.servlet.getServletConfig().getServletName();
            }
            if (servletName == null) {
                servletName = this.servlet.getServletInfo();
            }
            if (servletName == null) {
                servletName = this.servlet.getClass().getName();
            }
        }
        return servletName;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        Object result;
        Resource wrapped = this.wrapped;
        if (type == Servlet.class && this.servlet != null) {
            return (AdapterType)this.servlet;
        }
        if (type == InputStream.class && this.servlet instanceof BundledScriptServlet && (result = ((BundledScriptServlet)this.servlet).getInputStream()) != null) {
            return (AdapterType)result;
        }
        if (wrapped != null && (result = wrapped.adaptTo(type)) != null) {
            return (AdapterType)result;
        }
        if (type == ValueMap.class) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("sling:resourceType", this.getResourceType());
            props.put("sling:resourceSuperType", this.getResourceSuperType());
            if (this.servlet != null) {
                props.put("servletName", this.getServletName());
                props.put("servletClass", this.servlet.getClass().getName());
            }
            return (AdapterType)new ValueMapDecorator(props);
        }
        return (AdapterType)super.adaptTo(type);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", servlet=" + this.getServletName() + ", path=" + this.getPath();
    }
}

