/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.servlets.resolver.internal.ResolverConfig;
import org.apache.sling.servlets.resolver.internal.resolution.ResolutionCache;
import org.apache.sling.servlets.resolver.internal.resource.MergingServletResourceProvider;
import org.apache.sling.servlets.resolver.internal.resource.ServletResourceProvider;
import org.apache.sling.servlets.resolver.internal.resource.ServletResourceProviderFactory;
import org.apache.sling.servlets.resolver.internal.resource.SlingServletConfig;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.apache.sling.servlets.resolver.SlingServletResolver"}, immediate=true, service={ServletMounter.class})
public class ServletMounter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REF_SERVLET = "Servlet";
    private static final String REF_CACHE = "Cache";
    private final ServletContext servletContext;
    private final Map<ServiceReference<Servlet>, ServletReg> servletsByReference = new HashMap<ServiceReference<Servlet>, ServletReg>();
    private volatile boolean active = true;
    private final ServletResourceProviderFactory servletResourceProviderFactory;
    private final MergingServletResourceProvider provider;
    private final ServiceRegistration<MergingServletResourceProvider> providerReg;
    private final ConcurrentHashMap<ResolutionCache, ResolutionCache> resolutionCaches = new ConcurrentHashMap();
    private static final String[] NAME_PROPERTIES = new String[]{"sling.core.servletName", "component.name", "service.pid", "service.id"};

    @Activate
    public ServletMounter(BundleContext context, @Reference ResourceResolverFactory resourceResolverFactory, @Reference(target="(name=org.apache.sling)") ServletContext servletContext, ResolverConfig config) {
        this.servletContext = servletContext;
        this.servletResourceProviderFactory = new ServletResourceProviderFactory(config.servletresolver_servletRoot(), resourceResolverFactory.getSearchPath());
        if (!config.servletresolver_mountProviders()) {
            this.provider = new MergingServletResourceProvider();
            this.providerReg = context.registerService(MergingServletResourceProvider.class, (Object)this.provider, null);
        } else {
            this.provider = null;
            this.providerReg = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        ArrayList<ServiceReference<Servlet>> refs;
        this.active = false;
        Map<ServiceReference<Servlet>, ServletReg> map = this.servletsByReference;
        synchronized (map) {
            refs = new ArrayList<ServiceReference<Servlet>>(this.servletsByReference.keySet());
        }
        if (this.provider != null) {
            this.provider.clear();
        }
        this.destroyAllServlets(refs);
        if (this.providerReg != null) {
            this.providerReg.unregister();
        }
        map = this.servletsByReference;
        synchronized (map) {
            this.servletsByReference.clear();
        }
    }

    @Reference(name="Servlet", service=Servlet.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(|(sling.servlet.paths=*)(sling.servlet.resourceTypes=*))")
    public void bindServlet(Servlet servlet, ServiceReference<Servlet> reference) {
        if (this.active) {
            this.createServlet(servlet, reference);
        }
    }

    public void unbindServlet(ServiceReference<Servlet> reference) {
        this.destroyServlet(reference);
    }

    public boolean mountProviders() {
        return this.provider == null;
    }

    @Reference(name="Cache", service=ResolutionCache.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindResolutionCache(ResolutionCache cache) {
        if (this.provider != null) {
            cache.flushCache();
            this.resolutionCaches.put(cache, cache);
        }
    }

    protected void unbindResolutionCache(ResolutionCache cache) {
        if (this.provider != null) {
            this.resolutionCaches.remove(cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createServlet(Servlet servlet, ServiceReference<Servlet> reference) {
        BundleContext bundleContext;
        String name = ServletMounter.getName(reference);
        ServletResourceProvider srProvider = this.servletResourceProviderFactory.create(reference, servlet);
        if (srProvider == null) {
            return false;
        }
        try {
            servlet.init((ServletConfig)new SlingServletConfig(this.servletContext, reference, name));
            this.logger.debug("bindServlet: Servlet {} initialized", (Object)name);
        }
        catch (ServletException ce) {
            this.logger.error("bindServlet: Servlet " + ServletResourceProviderFactory.getServiceReferenceInfo(reference) + " failed to initialize", (Throwable)ce);
            return false;
        }
        catch (Throwable t) {
            this.logger.error("bindServlet: Unexpected problem initializing servlet " + ServletResourceProviderFactory.getServiceReferenceInfo(reference), t);
            return false;
        }
        boolean registered = false;
        Bundle bundle = reference.getBundle();
        if (bundle != null && (bundleContext = bundle.getBundleContext()) != null) {
            ArrayList<ServiceRegistration<ResourceProvider<Object>>> regs = new ArrayList<ServiceRegistration<ResourceProvider<Object>>>();
            try {
                if (this.provider != null) {
                    this.provider.add(srProvider, reference);
                    this.resolutionCaches.values().forEach(ResolutionCache::flushCache);
                } else {
                    for (String root : srProvider.getServletPaths()) {
                        ServiceRegistration reg = bundleContext.registerService(ResourceProvider.class.getName(), (Object)srProvider, this.createServiceProperties(reference, root));
                        regs.add((ServiceRegistration<ResourceProvider<Object>>)reg);
                    }
                }
                registered = true;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (registered) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Registered {}", (Object)srProvider);
                }
                Map<ServiceReference<Servlet>, ServletReg> map = this.servletsByReference;
                synchronized (map) {
                    this.servletsByReference.put(reference, new ServletReg(servlet, regs, srProvider));
                }
            }
        }
        if (!registered) {
            this.logger.debug("bindServlet: servlet has been unregistered in the meantime. Ignoring {}", (Object)name);
        }
        return true;
    }

    private Dictionary<String, Object> createServiceProperties(ServiceReference<Servlet> reference, String root) {
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        ((Dictionary)params).put("provider.root", root);
        ((Dictionary)params).put("service.description", "ServletResourceProvider for Servlet at " + root);
        Object rank = reference.getProperty("service.ranking");
        if (rank instanceof Integer) {
            ((Dictionary)params).put("service.ranking", rank);
        }
        return params;
    }

    private void destroyAllServlets(Collection<ServiceReference<Servlet>> refs) {
        for (ServiceReference<Servlet> serviceReference : refs) {
            this.destroyServlet(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyServlet(ServiceReference<Servlet> reference) {
        ServletReg registration;
        Map<ServiceReference<Servlet>, ServletReg> map = this.servletsByReference;
        synchronized (map) {
            registration = this.servletsByReference.remove(reference);
        }
        if (registration != null) {
            for (ServiceRegistration serviceRegistration : registration.registrations) {
                try {
                    serviceRegistration.unregister();
                }
                catch (IllegalStateException illegalStateException) {}
            }
            if (registration.provider != null && this.provider != null && this.provider.remove(registration.provider)) {
                this.resolutionCaches.values().forEach(ResolutionCache::flushCache);
            }
            String name = RequestUtil.getServletName((Servlet)registration.servlet);
            this.logger.debug("unbindServlet: Servlet {} removed", (Object)name);
            try {
                registration.servlet.destroy();
            }
            catch (Throwable throwable) {
                this.logger.error("unbindServlet: Unexpected problem destroying servlet " + name, throwable);
            }
        }
    }

    private static String getName(ServiceReference<Servlet> reference) {
        String servletName = null;
        for (int i = 0; i < NAME_PROPERTIES.length && (servletName == null || servletName.length() == 0); ++i) {
            Object prop = reference.getProperty(NAME_PROPERTIES[i]);
            if (prop == null) continue;
            servletName = String.valueOf(prop);
        }
        return servletName;
    }

    static final class ServletReg {
        public final Servlet servlet;
        public final List<ServiceRegistration<ResourceProvider<Object>>> registrations;
        private final ServletResourceProvider provider;

        public ServletReg(Servlet s, List<ServiceRegistration<ResourceProvider<Object>>> srs, ServletResourceProvider provider) {
            this.servlet = s;
            this.registrations = srs;
            this.provider = provider;
        }
    }
}

