/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.indexing;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.osgi.OsgiConsoleClient;
import org.apache.sling.testing.clients.query.QueryClient;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingClient
extends SlingClient {
    private static final Logger LOG = LoggerFactory.getLogger(IndexingClient.class);
    private static final String WAIT_FOR_ASYNC_INDEXING_ROOT = "/tmp/testing/waitForAsyncIndexing";
    private static final String INDEX_PATH = "/tmp/testing/waitForAsyncIndexing/oak:index";
    private static final String CONTENT_PATH = "/tmp/testing/waitForAsyncIndexing/content";
    private static final String INDEX_PREFIX = "testIndexingLane-";
    private static final String PROPERTY_PREFIX = "testProp-";
    private static final String VALUE_PREFIX = "testasyncval-";
    private static final String TAG_PREFIX = "testTag";
    private static final String INDEX_NAME_PLACEHOLDER = "<<INDEXNAME>>";
    private static final String PROPERTY_PLACEHOLDER = "<<PROPNAME>>";
    private static final String VALUE_PLACEHOLDER = "<<RANDVAL>>";
    private static final String LANE_PLACEHOLDER = "<<LANE>>";
    private static final String TAG_PLACEHOLDER = "<<TAG>>";
    private static final String INDEX_DEFINITION = "{  '<<INDEXNAME>>': {\n    'jcr:primaryType': 'oak:QueryIndexDefinition',\n    'type': 'lucene',\n    'async': '<<LANE>>',\n    'tags': '<<TAG>>',\n    'indexRules': {\n      'jcr:primaryType': 'nt:unstructured',\n      'nt:base': {\n        'jcr:primaryType': 'nt:unstructured',\n        'properties': {\n          'jcr:primaryType': 'nt:unstructured',\n          '<<PROPNAME>>': {\n            'jcr:primaryType': 'nt:unstructured',\n            'name': '<<PROPNAME>>',\n            'analyzed': true\n            }\n          }\n        }\n      }\n    }}";
    private static final String CONTENT_DEFINITION = "{'testContent-<<LANE>>-<<RANDVAL>>': {  'jcr:primaryType': 'nt:unstructured',   '<<PROPNAME>>': '<<RANDVAL>>'}}";
    private static final List<String> QUERIES = Arrays.asList("/jcr:root/tmp/testing/waitForAsyncIndexing//*[jcr:contains(@<<PROPNAME>>, '<<RANDVAL>>')] option(traversal ok, index tag <<TAG>>)", "/jcr:root/tmp/testing/waitForAsyncIndexing//*[jcr:contains(@<<PROPNAME>>, '<<RANDVAL>>')] option(traversal ok)");
    private static final AtomicLong totalWaited = new AtomicLong();

    public IndexingClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public IndexingClient(URI url, String user, String password) throws ClientException {
        super(url, user, password);
    }

    public List<String> getLaneNames() throws ClientException {
        try {
            Object asyncConfigs = this.adaptTo(OsgiConsoleClient.class).getConfiguration("org.apache.jackrabbit.oak.plugins.index.AsyncIndexerService", new int[0]).get("asyncConfigs");
            if (asyncConfigs instanceof String[]) {
                String[] configs = (String[])asyncConfigs;
                ArrayList<String> lanes = new ArrayList<String>(configs.length);
                for (String asyncConfig : configs) {
                    lanes.add(asyncConfig.split(":")[0]);
                }
                return lanes;
            }
            throw new ClientException("Cannot retrieve config from AsyncIndexerService, asyncConfigs is not a String[]");
        }
        catch (Exception e) {
            throw new ClientException("Failed to retrieve lanes", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAsyncIndexing(long timeout, long delay) throws TimeoutException, InterruptedException, ClientException {
        this.install();
        final String uniqueValue = UUID.randomUUID().toString();
        final List<String> lanes = this.getLaneNames();
        Polling p = new Polling(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return IndexingClient.this.searchContent(lanes, uniqueValue);
            }
        });
        try {
            this.createContent(lanes, uniqueValue);
            p.poll(timeout, delay);
        }
        finally {
            long total = totalWaited.addAndGet(p.getWaited());
            LOG.info("Waited for async index {} ms (overall: {} ms)", (Object)p.getWaited(), (Object)total);
            try {
                this.deleteContent(uniqueValue);
            }
            catch (ClientException e) {
                LOG.warn("Failed to delete temporary content", (Throwable)e);
            }
        }
    }

    public void waitForAsyncIndexing() throws InterruptedException, ClientException, TimeoutException {
        this.waitForAsyncIndexing(TimeUnit.MINUTES.toMillis(1L), 500L);
    }

    public void install() throws ClientException {
        if (this.exists(WAIT_FOR_ASYNC_INDEXING_ROOT)) {
            LOG.debug("Skipping install since {} already exists", (Object)WAIT_FOR_ASYNC_INDEXING_ROOT);
            return;
        }
        this.createNodeRecursive(WAIT_FOR_ASYNC_INDEXING_ROOT, "sling:Folder");
        this.createNode(INDEX_PATH, "nt:unstructured");
        this.createNode(CONTENT_PATH, "sling:Folder");
        List<String> lanes = this.getLaneNames();
        for (String lane : lanes) {
            String indexName = this.getIndexName(lane);
            String indexDefinition = this.replacePlaceholders(INDEX_DEFINITION, lane, null);
            LOG.info("Creating index {} in {}", (Object)indexName, (Object)INDEX_PATH);
            LOG.debug(indexDefinition);
            this.importContent(INDEX_PATH, "json", indexDefinition, new int[0]);
            this.setPropertyString("/tmp/testing/waitForAsyncIndexing/oak:index/" + indexName, "reindex", "true", new int[0]);
        }
    }

    public void uninstall() throws ClientException {
        this.deletePath(WAIT_FOR_ASYNC_INDEXING_ROOT, 200);
    }

    private void createContent(List<String> lanes, String uniqueValue) throws ClientException {
        String contentHolder = "/tmp/testing/waitForAsyncIndexing/content/" + uniqueValue;
        LOG.debug("creating content in {}", (Object)contentHolder);
        this.createNode(contentHolder, "sling:Folder");
        for (String lane : lanes) {
            String contentNode = this.replacePlaceholders(CONTENT_DEFINITION, lane, uniqueValue);
            LOG.debug("creating: {}", (Object)contentNode);
            this.importContent(contentHolder, "json", contentNode, new int[0]);
        }
    }

    private void deleteContent(String uniqueValue) throws ClientException {
        if (uniqueValue != null) {
            String contentHolder = "/tmp/testing/waitForAsyncIndexing/content/" + uniqueValue;
            LOG.debug("deleting {}", (Object)contentHolder);
            this.deletePath(contentHolder, 200);
        }
    }

    private boolean searchContent(List<String> lanes, String uniqueValue) throws ClientException, InterruptedException {
        for (String lane : lanes) {
            if (this.searchContentForIndex(lane, uniqueValue)) continue;
            return false;
        }
        return true;
    }

    private boolean searchContentForIndex(String lane, String uniqueValue) throws ClientException, InterruptedException {
        QueryClient queryClient = this.adaptTo(QueryClient.class);
        for (String query : QUERIES) {
            String indexName = this.getIndexName(lane);
            String effectiveQuery = this.replacePlaceholders(query, lane, uniqueValue);
            try {
                String plan = queryClient.getPlan(effectiveQuery, QueryClient.QueryType.XPATH);
                if (plan.contains(indexName)) {
                    long results = queryClient.doCount(effectiveQuery, QueryClient.QueryType.XPATH);
                    if (results <= 0L) continue;
                    LOG.debug("Found {} results using query {}", (Object)results, (Object)effectiveQuery);
                    return true;
                }
                LOG.debug("Did not find index {} in plan: {}", (Object)indexName, (Object)plan);
                LOG.debug("Will try the next query, if available");
            }
            catch (ClientException e) {
                if (e.getHttpStatusCode() == 400) {
                    LOG.debug("Unsupported query: {}", (Object)effectiveQuery);
                    LOG.debug("Will try the next query, if available");
                    continue;
                }
                throw e;
            }
        }
        return false;
    }

    private String replacePlaceholders(String original, String lane, String value) {
        String tag = StringUtils.capitalize((String)lane.replaceAll("[^A-Za-z0-9]", ""));
        String result = original;
        result = StringUtils.replace((String)result, (String)LANE_PLACEHOLDER, (String)lane);
        result = StringUtils.replace((String)result, (String)INDEX_NAME_PLACEHOLDER, (String)(INDEX_PREFIX + lane));
        result = StringUtils.replace((String)result, (String)PROPERTY_PLACEHOLDER, (String)(PROPERTY_PREFIX + lane));
        result = StringUtils.replace((String)result, (String)VALUE_PLACEHOLDER, (String)(VALUE_PREFIX + value));
        result = StringUtils.replace((String)result, (String)TAG_PLACEHOLDER, (String)(TAG_PREFIX + tag));
        return result;
    }

    private String getIndexName(String lane) {
        return INDEX_PREFIX + lane;
    }
}

