/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.util.ResourceUtil;

public class InputStreamBodyWithLength
extends InputStreamBody {
    private long streamLength;

    public InputStreamBodyWithLength(String resourcePath, String contentType, String fileName) throws ClientException {
        super(ResourceUtil.getResourceAsStream(resourcePath), ContentType.create((String)contentType), fileName);
        this.streamLength = InputStreamBodyWithLength.getResourceStreamLength(resourcePath);
    }

    public long getContentLength() {
        return this.streamLength;
    }

    private static long getResourceStreamLength(String resourcePath) throws ClientException {
        int streamLength = 0;
        InputStream stream = ResourceUtil.getResourceAsStream(resourcePath);
        try {
            int avail = stream.available();
            while (avail > 0) {
                streamLength += avail;
                stream.skip(avail);
                avail = stream.available();
            }
        }
        catch (IOException e) {
            throw new ClientException("Could not read " + resourcePath + "!", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new ClientException("Could not close Inputstream for " + resourcePath + "!", e);
            }
        }
        return streamLength;
    }
}

