/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.util.UUID;
import javax.jcr.Item;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.apache.sling.testing.mock.jcr.MockNode;
import org.apache.sling.testing.mock.jcr.MockProperty;
import org.apache.sling.testing.mock.jcr.ResourceUtil;

class ItemData {
    private final String path;
    private final String name;
    private final boolean isNode;
    private final String uuid;
    private final NodeType nodeType;
    private Value[] values;
    private boolean isMultiple;
    private boolean isNew;

    private ItemData(String path, boolean isNode, String uuid, NodeType nodeType) {
        this.path = path;
        this.name = ResourceUtil.getName(path);
        this.uuid = uuid;
        this.isNode = isNode;
        this.nodeType = nodeType;
        this.isNew = true;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNode() {
        return this.isNode;
    }

    public boolean isProperty() {
        return !this.isNode;
    }

    public String getUuid() {
        if (!this.isNode()) {
            throw new UnsupportedOperationException();
        }
        return this.uuid;
    }

    public NodeType getNodeType() {
        if (!this.isNode()) {
            throw new UnsupportedOperationException();
        }
        return this.nodeType;
    }

    public Value[] getValues() {
        if (!this.isProperty()) {
            throw new UnsupportedOperationException();
        }
        return this.values;
    }

    public void setValues(Value[] values) {
        if (!this.isProperty()) {
            throw new UnsupportedOperationException();
        }
        this.values = values;
    }

    public boolean isMultiple() {
        if (!this.isProperty()) {
            throw new UnsupportedOperationException();
        }
        return this.isMultiple;
    }

    public void setMultiple(boolean isMultiple) {
        if (!this.isProperty()) {
            throw new UnsupportedOperationException();
        }
        this.isMultiple = isMultiple;
    }

    public Item getItem(Session session) {
        if (this.isNode) {
            return new MockNode(this, session);
        }
        return new MockProperty(this, session);
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemData) {
            return this.path.equals(((ItemData)obj).path);
        }
        return false;
    }

    public static ItemData newNode(String path, NodeType nodeType) {
        return new ItemData(path, true, UUID.randomUUID().toString(), nodeType);
    }

    public static ItemData newProperty(String path) {
        return new ItemData(path, false, null, null);
    }
}

