/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.testing.mock.jcr.ItemData;
import org.apache.sling.testing.mock.jcr.MockSession;
import org.apache.sling.testing.mock.jcr.ResourceUtil;

abstract class AbstractItem
implements Item {
    protected final ItemData itemData;
    private final Session session;

    public AbstractItem(ItemData itemData, Session session) {
        this.itemData = itemData;
        this.session = session;
    }

    public String getName() throws RepositoryException {
        return this.itemData.getName();
    }

    public String getPath() throws RepositoryException {
        return this.itemData.getPath();
    }

    public Node getParent() throws RepositoryException {
        return (Node)this.getSession().getItem(ResourceUtil.getParent(this.getPath()));
    }

    public Session getSession() throws RepositoryException {
        return this.session;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isNew() {
        return this.itemData.isNew();
    }

    public Item getAncestor(int depth) throws RepositoryException {
        if (depth < 0 || depth > this.getDepth()) {
            throw new ItemNotFoundException();
        }
        return this.session.getItem(ResourceUtil.getParent(this.getPath(), depth));
    }

    protected String makeAbsolutePath(String relativePath) throws RepositoryException {
        String absolutePath = relativePath;
        if (!StringUtils.startsWith((CharSequence)absolutePath, (CharSequence)"/")) {
            absolutePath = this.getPath() + "/" + absolutePath;
        }
        return ResourceUtil.normalize(absolutePath);
    }

    protected MockSession getMockedSession() {
        return (MockSession)this.session;
    }

    public void remove() throws RepositoryException {
        this.getSession().removeItem(this.getPath());
    }

    public int getDepth() throws RepositoryException {
        if (StringUtils.equals((CharSequence)"/", (CharSequence)this.getPath())) {
            return 0;
        }
        return StringUtils.countMatches((CharSequence)this.getPath(), (CharSequence)"/");
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void save() throws RepositoryException {
        throw new UnsupportedOperationException();
    }
}

